/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.decoder;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.CommandContextFactory;

public class HttpCommandDecoder {
    public static CommandContext decode(HttpRequest request) {
        QueryStringDecoder queryStringDecoder;
        String path;
        String[] array;
        CommandContext commandContext = null;
        if (request != null && (array = (path = (queryStringDecoder = new QueryStringDecoder(request.getUri())).path()).split("/")).length == 2) {
            String name = array[1];
            if (request.getMethod() == HttpMethod.GET) {
                if (queryStringDecoder.parameters().isEmpty()) {
                    commandContext = CommandContextFactory.newInstance(name);
                    commandContext.setHttp(true);
                } else {
                    ArrayList valueList = new ArrayList();
                    for (List values : queryStringDecoder.parameters().values()) {
                        valueList.addAll(values);
                    }
                    commandContext = CommandContextFactory.newInstance(name, valueList.toArray(new String[0]), true);
                }
            } else if (request.getMethod() == HttpMethod.POST) {
                HttpPostRequestDecoder httpPostRequestDecoder = new HttpPostRequestDecoder(request);
                ArrayList<String> valueList = new ArrayList<String>();
                for (InterfaceHttpData interfaceHttpData : httpPostRequestDecoder.getBodyHttpDatas()) {
                    if (interfaceHttpData.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                    Attribute attribute = (Attribute)interfaceHttpData;
                    try {
                        valueList.add(attribute.getValue());
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (valueList.isEmpty()) {
                    commandContext = CommandContextFactory.newInstance(name);
                    commandContext.setHttp(true);
                } else {
                    commandContext = CommandContextFactory.newInstance(name, valueList.toArray(new String[0]), true);
                }
            }
        }
        return commandContext;
    }
}

