/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import com.alibaba.dubbo.config.annotation.Service;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.MethodComparator;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.ServiceAnnotationResolver;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.metadata.definition.MethodDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.MethodDefinition;
import org.apache.dubbo.metadata.rest.AnnotatedMethodParameterProcessor;
import org.apache.dubbo.metadata.rest.RequestMetadata;
import org.apache.dubbo.metadata.rest.RestMethodMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadataResolver;

public abstract class AbstractServiceRestMetadataResolver
implements ServiceRestMetadataResolver {
    private final Map<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = AbstractServiceRestMetadataResolver.loadAnnotatedMethodParameterProcessors();

    @Override
    public final boolean supports(Class<?> serviceType) {
        return this.isImplementedInterface(serviceType) && this.isServiceAnnotationPresent(serviceType) && this.supports0(serviceType);
    }

    protected final boolean isImplementedInterface(Class<?> serviceType) {
        return !ClassUtils.getAllInterfaces(serviceType, new Predicate[0]).isEmpty();
    }

    protected final boolean isServiceAnnotationPresent(Class<?> serviceType) {
        return AnnotationUtils.isAnyAnnotationPresent(serviceType, DubboService.class, org.apache.dubbo.config.annotation.Service.class, Service.class);
    }

    protected abstract boolean supports0(Class<?> var1);

    @Override
    public final ServiceRestMetadata resolve(Class<?> serviceType) {
        ServiceRestMetadata serviceRestMetadata = new ServiceRestMetadata();
        this.processServiceRestMetadata(serviceRestMetadata, serviceType);
        this.processAllRestMethodMetadata(serviceRestMetadata, serviceType);
        return serviceRestMetadata;
    }

    protected void processServiceRestMetadata(ServiceRestMetadata serviceRestMetadata, Class<?> serviceType) {
        ServiceAnnotationResolver resolver = new ServiceAnnotationResolver(serviceType);
        serviceRestMetadata.setServiceInterface(resolver.resolveInterfaceClassName());
        serviceRestMetadata.setVersion(resolver.resolveVersion());
        serviceRestMetadata.setGroup(resolver.resolveGroup());
    }

    protected void processAllRestMethodMetadata(ServiceRestMetadata serviceRestMetadata, Class<?> serviceType) {
        Class<?> serviceInterfaceClass = this.resolveServiceInterfaceClass(serviceRestMetadata, serviceType);
        Map<Method, Method> serviceMethodsMap = this.resolveServiceMethodsMap(serviceType, serviceInterfaceClass);
        for (Map.Entry<Method, Method> entry : serviceMethodsMap.entrySet()) {
            Method serviceMethod = entry.getKey();
            if (this.processRestMethodMetadata(serviceMethod, serviceType, serviceInterfaceClass, serviceRestMetadata.getMeta()::add)) continue;
            Method declaredServiceMethod = entry.getValue();
            this.processRestMethodMetadata(declaredServiceMethod, serviceType, serviceInterfaceClass, serviceRestMetadata.getMeta()::add);
        }
    }

    protected Map<Method, Method> resolveServiceMethodsMap(Class<?> serviceType, Class<?> serviceInterfaceClass) {
        LinkedHashMap<Method, Method> serviceMethodsMap = new LinkedHashMap<Method, Method>();
        ArrayList<Method> declaredServiceMethods = new ArrayList<Method>(MethodUtils.getAllMethods(serviceInterfaceClass, MethodUtils.excludedDeclaredClass(Object.class)));
        ArrayList<Method> serviceMethods = new ArrayList<Method>(MethodUtils.getAllMethods(serviceType, MethodUtils.excludedDeclaredClass(Object.class)));
        Collections.sort(declaredServiceMethods, MethodComparator.INSTANCE);
        Collections.sort(serviceMethods, MethodComparator.INSTANCE);
        for (Method declaredServiceMethod : declaredServiceMethods) {
            for (Method serviceMethod : serviceMethods) {
                if (!MethodUtils.overrides(serviceMethod, declaredServiceMethod)) continue;
                serviceMethodsMap.put(serviceMethod, declaredServiceMethod);
            }
        }
        return Collections.unmodifiableMap(serviceMethodsMap);
    }

    protected Class<?> resolveServiceInterfaceClass(ServiceRestMetadata serviceRestMetadata, Class<?> serviceType) {
        return ThrowableFunction.execute(serviceType.getClassLoader(), classLoader -> {
            String serviceInterface = serviceRestMetadata.getServiceInterface();
            return ClassUtils.forName(serviceInterface, classLoader);
        });
    }

    protected boolean processRestMethodMetadata(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Consumer<RestMethodMetadata> metadataToProcess) {
        if (!this.isRestCapableMethod(serviceMethod, serviceType, serviceInterfaceClass)) {
            return false;
        }
        String requestPath = this.resolveRequestPath(serviceMethod, serviceType, serviceInterfaceClass);
        if (requestPath == null) {
            return false;
        }
        String requestMethod = this.resolveRequestMethod(serviceMethod, serviceType, serviceInterfaceClass);
        if (requestMethod == null) {
            return false;
        }
        RestMethodMetadata metadata = new RestMethodMetadata();
        MethodDefinition methodDefinition = this.resolveMethodDefinition(serviceMethod, serviceType, serviceInterfaceClass);
        metadata.setMethod(methodDefinition);
        this.processAnnotatedMethodParameters(serviceMethod, serviceType, serviceInterfaceClass, metadata);
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        this.processProduces(serviceMethod, serviceType, serviceInterfaceClass, produces);
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        this.processConsumes(serviceMethod, serviceType, serviceInterfaceClass, consumes);
        RequestMetadata request = metadata.getRequest();
        request.setPath(requestPath);
        request.setMethod(requestMethod);
        request.setProduces(produces);
        request.setConsumes(consumes);
        this.postResolveRestMethodMetadata(serviceMethod, serviceType, serviceInterfaceClass, metadata);
        metadataToProcess.accept(metadata);
        return true;
    }

    protected abstract boolean isRestCapableMethod(Method var1, Class<?> var2, Class<?> var3);

    protected abstract String resolveRequestMethod(Method var1, Class<?> var2, Class<?> var3);

    protected abstract String resolveRequestPath(Method var1, Class<?> var2, Class<?> var3);

    protected MethodDefinition resolveMethodDefinition(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        MethodDefinitionBuilder builder = new MethodDefinitionBuilder();
        return builder.build(serviceMethod);
    }

    private void processAnnotatedMethodParameters(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, RestMethodMetadata metadata) {
        int paramCount = serviceMethod.getParameterCount();
        Parameter[] parameters = serviceMethod.getParameters();
        for (int i = 0; i < paramCount; ++i) {
            Parameter parameter = parameters[i];
            metadata.addIndexToName(i, parameter.getName());
            this.processAnnotatedMethodParameter(parameter, i, serviceMethod, serviceType, serviceInterfaceClass, metadata);
        }
    }

    private void processAnnotatedMethodParameter(Parameter parameter, int parameterIndex, Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, RestMethodMetadata metadata) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = parameter.getAnnotations()) {
            String annotationType = annotation.annotationType().getName();
            this.parameterProcessorsMap.getOrDefault(annotationType, Collections.emptyList()).forEach(processor -> processor.process(annotation, parameter, parameterIndex, serviceMethod, serviceType, serviceInterfaceClass, metadata));
        }
    }

    protected abstract void processProduces(Method var1, Class<?> var2, Class<?> var3, Set<String> var4);

    protected abstract void processConsumes(Method var1, Class<?> var2, Class<?> var3, Set<String> var4);

    protected void postResolveRestMethodMetadata(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, RestMethodMetadata metadata) {
    }

    private static Map<String, List<AnnotatedMethodParameterProcessor>> loadAnnotatedMethodParameterProcessors() {
        LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>> parameterProcessorsMap = new LinkedHashMap<String, List<AnnotatedMethodParameterProcessor>>();
        ExtensionLoader.getExtensionLoader(AnnotatedMethodParameterProcessor.class).getSupportedExtensionInstances().forEach(processor -> {
            List processors = parameterProcessorsMap.computeIfAbsent(processor.getAnnotationType(), k -> new LinkedList());
            processors.add(processor);
        });
        return parameterProcessorsMap;
    }
}

