/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.es.consumer;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.common.HashUtil;
import org.apache.ozhera.trace.etl.domain.HeraTraceEtlConfig;
import org.apache.ozhera.trace.etl.es.config.TraceConfig;
import org.apache.ozhera.trace.etl.es.domain.FilterResult;
import org.apache.ozhera.trace.etl.es.util.bloomfilter.TraceIdRedisBloomUtil;
import org.apache.ozhera.trace.etl.service.HeraContextService;
import org.apache.ozhera.tspandata.TSpanData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilterService {
    private static final Logger log = LoggerFactory.getLogger(FilterService.class);
    @NacosValue(value="${trace.es.filter.spanname}", autoRefreshed=true)
    private String filterSpanName;
    @NacosValue(value="${trace.es.filter.app.name}", autoRefreshed=true)
    private String appName;
    @NacosValue(value="${trace.threshold}", autoRefreshed=true)
    private int defThreshold;
    @NacosValue(value="${trace.duration.threshold}", autoRefreshed=true)
    private int defDurationThreshold;
    @NacosValue(value="${trace.es.filter.isopen}", autoRefreshed=true)
    private boolean filterIsOpen;
    @NacosValue(value="${trace.es.filter.random.base}", autoRefreshed=true)
    private int randomBase;
    @Autowired
    private TraceIdRedisBloomUtil traceIdRedisBloomUtil;
    @Autowired
    private TraceConfig traceConfig;
    @Autowired
    private HeraContextService heraContextService;

    public FilterResult filterBefore(String statusCode, String traceId, String spanName, String heraContext, String serviceName, long duration, TSpanData tSpanData) {
        FilterResult filterResult = new FilterResult();
        if (this.filterSpanName.contains(spanName)) {
            filterResult.setDiscard(true);
            return filterResult;
        }
        if (this.appName.contains(serviceName)) {
            filterResult.setDiscard(true);
            return filterResult;
        }
        if (this.filterIsOpen) {
            int durationThreshold;
            if ("ERROR".equals(statusCode)) {
                filterResult.setResult(true);
                filterResult.setAddBloom(true);
                return filterResult;
            }
            HeraTraceEtlConfig config = this.traceConfig.getConfig(serviceName);
            if (this.checkHeraContext(heraContext, config)) {
                filterResult.setResult(true);
                filterResult.setAddBloom(true);
                return filterResult;
            }
            int n = durationThreshold = config == null ? this.defDurationThreshold : config.getTraceDurationThreshold();
            if (duration / 1000000L > (long)durationThreshold) {
                filterResult.setResult(true);
                filterResult.setAddBloom(true);
                return filterResult;
            }
            boolean filterRandom = this.filterRandom(serviceName, traceId);
            if (filterRandom) {
                filterResult.setResult(true);
                filterResult.setAddBloom(false);
                return filterResult;
            }
            if (this.traceIdRedisBloomUtil.isExistLocal(traceId)) {
                filterResult.setResult(true);
                filterResult.setAddBloom(false);
                return filterResult;
            }
            filterResult.setResult(false);
            return filterResult;
        }
        filterResult.setResult(true);
        filterResult.setAddBloom(false);
        return filterResult;
    }

    public boolean filterRandom(String serviceName, String traceId) {
        int threshold;
        HeraTraceEtlConfig config = this.traceConfig.getConfig(serviceName);
        int i = HashUtil.consistentHash((String)traceId, (int)this.randomBase);
        int n = threshold = config == null ? this.defThreshold : config.getTraceFilter();
        return i < threshold;
    }

    private boolean checkHeraContext(String heraContext, HeraTraceEtlConfig config) {
        if (config != null && StringUtils.isNotEmpty((CharSequence)heraContext) && StringUtils.isNotEmpty((CharSequence)config.getTraceDebugFlag())) {
            String[] flags = config.getTraceDebugFlag().split("\\|");
            Set heraContextKeys = this.heraContextService.getHeraContextKeys(heraContext);
            for (String flag : flags) {
                for (String heraContextKey : heraContextKeys) {
                    if (!flag.equals(heraContextKey)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

