/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.kafka;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.ozhera.trace.etl.api.service.MQExtension;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.extension.kafka.KafkaConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mq.type"}, havingValue="kafka")
public class KafkaExtension
implements MQExtension<ProducerRecord<String, String>, ConsumerRecords<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(KafkaExtension.class);
    @NacosValue(value="${kafka.vpc.type}")
    private String vpcType;
    @Autowired
    private KafkaConfigure kafkaConfigure;
    private KafkaProducer<String, String> producer;
    private String topic;
    private KafkaConsumer<String, String> consumer;

    public void initMq(MqConfig<ConsumerRecords<String, String>> config) {
        log.info("init rocketmq");
        if (StringUtils.isNotEmpty((CharSequence)config.getProducerTopicName())) {
            this.initProducer(config);
        }
        this.initConsumer(config);
    }

    private void initProducer(MqConfig<ConsumerRecords<String, String>> config) {
        try {
            log.info("init producer start ...");
            Properties props = this.kafkaConfigure.createProducerProperties(config);
            props.put("acks", "0");
            props.put("batch.size", (Object)563840);
            props.put("linger.ms", (Object)1000);
            props.put("buffer.memory", (Object)0x2000000);
            props.put("compression.type", "lz4");
            this.producer = new KafkaProducer(props);
            this.topic = config.getProducerTopicName();
            log.info("init producer end ...");
        }
        catch (Throwable ex) {
            log.error("init producer error", ex);
            throw new RuntimeException(ex);
        }
    }

    private void initConsumer(MqConfig<ConsumerRecords<String, String>> config) {
        try {
            log.info("init consumer start ...");
            Properties props = this.kafkaConfigure.createConsumerProperties(config);
            props.put("compression.type", "lz4");
            this.consumer = new KafkaConsumer(props);
            ArrayList<String> subscribedTopics = new ArrayList<String>();
            subscribedTopics.add(config.getConsumerTopicName());
            this.consumer.subscribe(subscribedTopics);
            Executors.newSingleThreadExecutor().submit(() -> {
                while (true) {
                    this.consumer(config);
                }
            });
            log.info("init consumer end ...");
        }
        catch (Throwable ex) {
            log.error("init error", ex);
            throw new RuntimeException(ex);
        }
    }

    private void consumer(MqConfig<ConsumerRecords<String, String>> config) {
        try {
            ConsumerRecords records = this.consumer.poll(1000L);
            config.getConsumerMethod().apply(records);
        }
        catch (Throwable t) {
            log.error("consumer message error , ", t);
        }
    }

    public void send(ProducerRecord<String, String> message) {
        this.send(Collections.singletonList(message));
    }

    public void send(List<ProducerRecord<String, String>> messages) {
        try {
            for (ProducerRecord<String, String> message : messages) {
                this.producer.send(message);
            }
        }
        catch (Throwable t) {
            log.error("send message error, ", t);
        }
    }

    public void sendByTraceId(String traceId, ProducerRecord<String, String> message) {
    }
}

