/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.client.identify.Base64;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static String sign(String data, String key) throws Exception {
        try {
            byte[] signature = SignUtil.sign(data.getBytes(UTF8), key.getBytes(UTF8), SigningAlgorithm.HmacSHA1);
            return new String(Base64.encodeBase64(signature));
        }
        catch (Exception var3) {
            throw new Exception("Unable to calculate a request signature: " + var3.getMessage(), var3);
        }
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws Exception {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception var4) {
            throw new Exception("Unable to calculate a request signature: " + var4.getMessage(), var4);
        }
    }

    public static enum SigningAlgorithm {
        HmacSHA1;

    }
}

