/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.jcommon.log;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.xiaomi.youpin.jcommon.log.LogEvent;
import com.xiaomi.youpin.jcommon.log.LogEventHandler;
import com.xiaomi.youpin.jcommon.log.LogRecord;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class LogDisruptor {
    private Disruptor<LogEvent> disruptor;

    public boolean start(Consumer<LogRecord> consumer) {
        try {
            EventFactory eventFactory = () -> new LogEvent();
            ExecutorService executor = Executors.newCachedThreadPool();
            int ringBufferSize = 0x100000;
            this.disruptor = new Disruptor(eventFactory, ringBufferSize, (Executor)executor, ProducerType.MULTI, (WaitStrategy)new YieldingWaitStrategy());
            this.disruptor.handleEventsWith(new EventHandler[]{new LogEventHandler(consumer)});
            this.disruptor.start();
            return true;
        }
        catch (Throwable ex) {
            System.err.println(ex.getMessage());
            return false;
        }
    }

    public void publishEvent(Consumer<LogRecord> consumer) {
        try {
            this.disruptor.publishEvent((logEvent, sequence) -> consumer.accept(logEvent.getLogRecord()));
        }
        catch (Throwable ex) {
            System.err.println(ex.getMessage());
        }
    }
}

