/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.es;

import java.util.List;
import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.domain.DriverDomain;
import org.apache.ozhera.trace.etl.domain.ErrorTraceMessage;
import org.apache.ozhera.trace.etl.domain.tracequery.Trace;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceIdQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceListQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceOperationsVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceQueryResult;
import org.apache.ozhera.trace.etl.extension.es.QueryEsService;
import org.apache.ozhera.trace.etl.extension.es.WriteEsService;
import org.apache.ozhera.tspandata.TSpanData;
import org.springframework.beans.factory.annotation.Autowired;

public class EsDataSourceService
implements DataSourceService {
    @Autowired
    private QueryEsService queryEsService;
    @Autowired
    private WriteEsService writeEsService;

    public TraceQueryResult<List<String>> getOperations(TraceOperationsVo vo) {
        return this.queryEsService.getOperations(vo.getService(), vo.getIndex());
    }

    public TraceQueryResult<List<Trace>> getList(TraceListQueryVo vo) {
        return this.queryEsService.getList(vo);
    }

    public TraceQueryResult<List<Trace>> getByTraceId(TraceIdQueryVo vo) {
        return this.queryEsService.getByTraceId(vo);
    }

    public void insertErrorTrace(ErrorTraceMessage errorTraceMessage) {
        this.writeEsService.submitErrorEsTrace(errorTraceMessage);
    }

    public void insertHeraTraceService(String date, String serviceName, String oprationName) {
        this.writeEsService.insertJaegerService(date, serviceName, oprationName);
    }

    public void insertDriver(DriverDomain driverDomain) {
        this.writeEsService.insertDriver(driverDomain);
    }

    public void insertHeraSpan(TSpanData tSpanData, String serviceName, String spanName) {
        this.writeEsService.insertJaegerSpan(tSpanData, serviceName, spanName);
    }
}

