/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.mone.file.common.FileInfo;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfoCache {
    private static final Logger log = LoggerFactory.getLogger(FileInfoCache.class);
    private ConcurrentHashMap<String, FileInfo> cache = new ConcurrentHashMap();
    private Gson gson = new GsonBuilder().setLenient().create();
    private String filePath = "/tmp/.ozhera_pointer";
    private volatile boolean loaded = false;

    public static final FileInfoCache ins() {
        return LazyHolder.ins;
    }

    public void put(String key, FileInfo val) {
        this.cache.put(key, val);
    }

    public FileInfo get(String key) {
        return this.cache.get(key);
    }

    public void remove(String key) {
        this.cache.remove(key);
    }

    public ConcurrentMap<String, FileInfo> caches() {
        return this.cache;
    }

    public void shutdown() {
        log.info("cache shutdown size:{}", (Object)this.cache.size());
        String str = this.gson.toJson(this.cache);
        FileWriter writer = new FileWriter(this.filePath, false);
        writer.append(str);
        writer.flush();
        writer.close();
    }

    public void load() {
        if (!this.loaded && new File(this.filePath).exists()) {
            this.loaded = true;
            String str = new String(Files.readAllBytes(Paths.get(this.filePath, new String[0])));
            Type typeOfT = new TypeToken<Map<String, FileInfo>>(this){}.getType();
            Map map = (Map)this.gson.fromJson(str, typeOfT);
            map.forEach((k, v) -> this.cache.put((String)k, (FileInfo)v));
            log.info("cache load size:{}", (Object)this.cache.size());
        }
    }

    public void load(String filePath) {
        try {
            this.filePath = filePath;
            this.load();
        }
        catch (Exception e) {
            log.error("load cache error,filePath:{}", (Object)filePath, (Object)e);
        }
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private static final class LazyHolder {
        private static final FileInfoCache ins = new FileInfoCache();

        private LazyHolder() {
        }
    }
}

