/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.manager.controller;

import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceIdQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceListQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceOperationsVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tracing/v1"})
public class TraceController {
    private static final Logger log = LoggerFactory.getLogger(TraceController.class);
    @Autowired
    private DataSourceService dataSourceService;
    @Value(value="${es.trace.index.prefix}")
    private String spanIndexPrefix;
    @Value(value="${es.trace.index.service.prefix}")
    private String serviceIndexPrefix;

    @GetMapping(value={"/app/operations"})
    public TraceQueryResult operations(TraceOperationsVo vo) {
        vo.setIndex(this.serviceIndexPrefix);
        return this.dataSourceService.getOperations(vo);
    }

    @GetMapping(value={"/trace/list"})
    public TraceQueryResult getList(TraceListQueryVo vo) {
        vo.setIndex(this.spanIndexPrefix);
        return this.dataSourceService.getList(vo);
    }

    @GetMapping(value={"/trace/{traceId}"})
    public TraceQueryResult getByTraceId(@PathVariable String traceId, TraceIdQueryVo vo) {
        vo.setIndex(this.spanIndexPrefix);
        vo.setTraceId(traceId);
        return this.dataSourceService.getByTraceId(vo);
    }
}

