/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.uds.codes;

import com.xiaomi.data.push.uds.codes.ICodes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Type;
import java.util.stream.IntStream;

public class BytesCodes
implements ICodes {
    @Override
    public <T> T decode(byte[] data, Type type) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        return this.decode(buf, type);
    }

    public <T> T decode(ByteBuf buf, Type type) {
        if (type.equals(byte[][].class)) {
            int row = buf.readInt();
            byte[][] bytes = new byte[row][];
            for (int i2 = 0; i2 < row; ++i2) {
                int col = buf.readInt();
                byte[] bb = new byte[col];
                for (int j = 0; j < col; ++j) {
                    bb[j] = buf.readByte();
                }
                bytes[i2] = bb;
            }
            return (T)bytes;
        }
        if (type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(buf.readByte() == 1);
        }
        if (type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(buf.readInt());
        }
        if (type.equals(Long.TYPE)) {
            return (T)Long.valueOf(buf.readLong());
        }
        if (type.equals(String.class)) {
            int len = buf.readInt();
            byte[] d = new byte[len];
            buf.readBytes(d);
            return (T)new String(d);
        }
        if (type.equals(String[].class)) {
            int len = buf.readInt();
            String[] strs = new String[len];
            IntStream.range(0, len).forEach(i -> {
                int l = buf.readInt();
                byte[] d = new byte[l];
                buf.readBytes(d);
                strs[i] = new String(d);
            });
            return (T)strs;
        }
        return null;
    }

    @Override
    public <T> byte[] encode(T t) {
        if (t.getClass().equals(byte[][].class)) {
            byte[][] bytes = (byte[][])t;
            int row = bytes.length;
            CompositeByteBuf buffer = Unpooled.compositeBuffer((int)(2 + row));
            buffer.addComponents(true, new ByteBuf[]{Unpooled.buffer((int)4).writeInt(row)});
            for (int i2 = 0; i2 < row; ++i2) {
                int col = bytes[i2].length;
                buffer.addComponents(true, new ByteBuf[]{Unpooled.buffer((int)4).writeInt(col)});
                ByteBuf buf = Unpooled.buffer((int)(row * col));
                for (int j = 0; j < col; ++j) {
                    buf.writeByte((int)bytes[i2][j]);
                }
                buffer.addComponents(true, new ByteBuf[]{buf});
            }
            int capacity = buffer.capacity();
            byte[] data = new byte[capacity];
            buffer.readBytes(data);
            return data;
        }
        if (t.getClass().equals(Boolean.TYPE) || t.getClass().equals(Boolean.class)) {
            byte[] byArray;
            if (((Boolean)t).booleanValue()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            return byArray;
        }
        if (t.getClass().equals(Integer.class) || t.getClass().equals(Integer.TYPE)) {
            return this.int2Bytes((Integer)t);
        }
        if (t.getClass().equals(Long.class) || t.getClass().equals(Long.TYPE)) {
            return this.long2Bytes((Long)t);
        }
        if (t.getClass().equals(String.class)) {
            String str = (String)t;
            byte[] data = str.getBytes();
            byte[] len = this.int2Bytes(data.length);
            byte[] c = new byte[len.length + data.length];
            System.arraycopy(len, 0, c, 0, len.length);
            System.arraycopy(data, 0, c, len.length, data.length);
            return c;
        }
        if (t.getClass().equals(String[].class)) {
            String[] strs = (String[])t;
            CompositeByteBuf buffer = Unpooled.compositeBuffer((int)(1 + strs.length));
            buffer.addComponents(true, new ByteBuf[]{Unpooled.buffer((int)4).writeInt(strs.length)});
            IntStream.range(0, strs.length).forEach(i -> {
                buffer.addComponents(true, new ByteBuf[]{Unpooled.buffer((int)4).writeInt(strs[i].length())});
                buffer.addComponents(true, new ByteBuf[]{Unpooled.buffer((int)strs[i].length()).writeBytes(strs[i].getBytes())});
            });
            int capacity = buffer.capacity();
            byte[] data = new byte[capacity];
            buffer.readBytes(data);
            return data;
        }
        return new byte[0];
    }

    private byte[] int2Bytes(int data) {
        return new byte[]{(byte)(data >> 24 & 0xFF), (byte)(data >> 16 & 0xFF), (byte)(data >> 8 & 0xFF), (byte)(data >> 0 & 0xFF)};
    }

    private byte[] long2Bytes(long data) {
        return new byte[]{(byte)(data >> 56 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    @Override
    public byte type() {
        return 2;
    }
}

