/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.rocketmq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.trace.etl.api.service.MQExtension;
import org.apache.ozhera.trace.etl.bo.MqConfig;
import org.apache.ozhera.trace.etl.extension.rocketmq.ClientMessageQueue;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"mq.type"}, havingValue="rocketMQ")
public class RocketMQExtension
implements MQExtension<MessageExt, MessageExt> {
    private static final Logger log = LoggerFactory.getLogger(RocketMQExtension.class);
    private Function<List<MessageExt>, Boolean> batchConsumerMethod;
    private DefaultMQProducer producer;
    private String topic;
    private ClientMessageQueue clientMessageQueue;

    public void initMq(MqConfig<MessageExt> config) {
        log.info("init rocketmq");
        if (StringUtils.isNotEmpty((CharSequence)config.getProducerTopicName())) {
            this.initProducer(config);
        }
        this.initConsumer(config);
    }

    private void initProducer(MqConfig<MessageExt> config) {
        try {
            log.info("init producer start ...");
            this.topic = config.getProducerTopicName();
            this.producer = new DefaultMQProducer(config.getProducerGroup());
            this.producer.setNamesrvAddr(config.getNameSerAddr());
            this.producer.start();
            this.clientMessageQueue = new ClientMessageQueue(this);
            this.clientMessageQueue.initFetchQueueTask();
            log.info("init producer end ...");
        }
        catch (Throwable ex) {
            log.error("init producer error", ex);
            throw new RuntimeException(ex);
        }
    }

    private void initConsumer(MqConfig<MessageExt> config) {
        try {
            log.info("init consumer start ...");
            this.batchConsumerMethod = config.getBatchConsumerMethod();
            DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(config.getConsumerGroup());
            consumer.setNamesrvAddr(config.getNameSerAddr());
            consumer.subscribe(config.getConsumerTopicName(), "*");
            consumer.registerMessageListener((MessageListenerConcurrently)new TraceEtlMessageListener());
            consumer.start();
            log.info("init consumer end ...");
        }
        catch (Throwable ex) {
            log.error("init error", ex);
            throw new RuntimeException(ex);
        }
    }

    public void send(MessageExt message) {
        this.send(Collections.singletonList(message));
    }

    public void send(List<MessageExt> messages) {
        ArrayList<Message> list = new ArrayList<Message>();
        for (MessageExt message : messages) {
            Message msg = new Message();
            msg.setBody(message.getBody());
            msg.setTopic(this.topic);
            list.add(msg);
        }
        try {
            this.producer.send(list);
        }
        catch (Throwable t) {
            log.error("rocketmq producer send error", t);
        }
    }

    public void sendByTraceId(String traceId, MessageExt message) {
        this.clientMessageQueue.enqueue(traceId, message);
    }

    public List<MessageQueue> fetchMessageQueue() {
        try {
            return this.producer.fetchPublishMessageQueues(this.topic);
        }
        catch (MQClientException e) {
            log.error("fetch queue task error : ", (Throwable)e);
            return new ArrayList<MessageQueue>();
        }
    }

    public void send(List<MessageExt> messages, MessageQueue messageQueue) {
        ArrayList<Message> list = new ArrayList<Message>();
        for (MessageExt message : messages) {
            Message msg = new Message();
            msg.setBody(message.getBody());
            msg.setTopic(this.topic);
            list.add(msg);
        }
        try {
            this.producer.send(list, messageQueue);
        }
        catch (Throwable t) {
            log.error("rocketmq producer send error", t);
        }
    }

    private class TraceEtlMessageListener
    implements MessageListenerConcurrently {
        private TraceEtlMessageListener() {
        }

        public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> list, ConsumeConcurrentlyContext consumeConcurrentlyContext) {
            if (list == null || list.isEmpty()) {
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
            RocketMQExtension.this.batchConsumerMethod.apply(list);
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
    }
}

