/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.rocketmq;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.ozhera.trace.etl.common.HashUtil;
import org.apache.ozhera.trace.etl.extension.rocketmq.ClientMessageQueueWrapper;
import org.apache.ozhera.trace.etl.extension.rocketmq.RocketMQExtension;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMessageQueue {
    private static final Logger log = LoggerFactory.getLogger(ClientMessageQueue.class);
    public List<ClientMessageQueueWrapper> clientMessageQueues = new CopyOnWriteArrayList<ClientMessageQueueWrapper>();
    private volatile int rocketMQQueueSize;
    private RocketMQExtension producer;
    private static final int CLIENT_QUEUE_SIZE = 2000;
    private static final int FETCH_ROCKETMQ_QUEUE_GAP = 10;

    public ClientMessageQueue(RocketMQExtension producer) {
        this.producer = producer;
    }

    public void setRocketMQQueueSize(int size) {
        this.rocketMQQueueSize = size;
    }

    public void checkClientQueue(List<MessageQueue> queueList) {
        if (queueList == null || queueList.size() == 0) {
            return;
        }
        queueList.stream().filter(i -> !this.clientMessageQueues.stream().anyMatch(j -> j.getRocketMQMessageQueue().equals(i))).forEach(queue -> this.clientMessageQueues.add(new ClientMessageQueueWrapper((MessageQueue)queue, (BlockingQueue<MessageExt>)new ArrayBlockingQueue<MessageExt>(2000), this.producer)));
        this.setRocketMQQueueSize(queueList.size());
        List<ClientMessageQueueWrapper> collect = this.clientMessageQueues.stream().filter(i -> !queueList.contains(i.getRocketMQMessageQueue())).collect(Collectors.toList());
        this.clientMessageQueues.stream().filter(i -> !queueList.contains(i.getRocketMQMessageQueue())).forEach(this.clientMessageQueues::remove);
        collect.forEach(ClientMessageQueueWrapper::stopExport);
    }

    public void enqueue(String traceId, MessageExt message) {
        try {
            int i = HashUtil.consistentHash((String)traceId, (int)this.rocketMQQueueSize);
            ClientMessageQueueWrapper clientMessageQueueWrapper = this.clientMessageQueues.get(i);
            clientMessageQueueWrapper.getClientMessageQueue().put(message);
        }
        catch (Throwable t) {
            log.error("client queue enqueue error : ", t);
        }
    }

    public void initFetchQueueTask() {
        new ScheduledThreadPoolExecutor(1).scheduleAtFixedRate(() -> {
            List<MessageQueue> messageQueues = this.producer.fetchMessageQueue();
            log.info("fetch message queue size : " + messageQueues.size());
            if (messageQueues == null || messageQueues.size() == 0) {
                return;
            }
            this.checkClientQueue(messageQueues);
        }, 0L, 10L, TimeUnit.SECONDS);
    }
}

