/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ozhera.prometheus.agent.domain.Ips;
import org.apache.ozhera.prometheus.agent.service.MioneMachineService;
import org.apache.ozhera.prometheus.agent.service.PrometheusIpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrometheusController {
    private static final Logger log = LoggerFactory.getLogger(PrometheusController.class);
    @Autowired
    private PrometheusIpService prometheusIpService;
    @Autowired
    private MioneMachineService mioneMachineService;

    @GetMapping(value={"/prometheus/getips"})
    public List<Ips> getips(String type) {
        return this.prometheusIpService.getByType(type);
    }

    @GetMapping(value={"/prometheus/getMachineList"})
    public List<Ips> getMachineList(String type) {
        return this.mioneMachineService.queryMachineList(type);
    }

    @GetMapping(value={"/prometheus/getIpsByAppName"})
    public List<Ips> getIpsByAppName(String appName) {
        Set tmpResult = this.prometheusIpService.getIpsByAppName(appName);
        ArrayList result = new ArrayList(tmpResult);
        ArrayList<Ips> defaultResult = new ArrayList<Ips>();
        Ips ips = new Ips();
        ips.setTargets(result);
        defaultResult.add(ips);
        return defaultResult;
    }

    @GetMapping(value={"/prometheus/getEtcd"})
    public List<Ips> getEtcd() {
        Set tmpresult = this.prometheusIpService.getEtcdHosts();
        ArrayList result = new ArrayList(tmpresult);
        ArrayList<Ips> defaultResult = new ArrayList<Ips>();
        Ips ips = new Ips();
        ips.setTargets(result);
        defaultResult.add(ips);
        return defaultResult;
    }

    @GetMapping(value={"/prometheus/getK8sNodeIp"})
    public List<Ips> getK8sNodeIp(String type) {
        return this.prometheusIpService.getK8sNodeIp(type);
    }

    @GetMapping(value={"/prometheus/getHeraAppPodIp"})
    public List<Ips> getHeraAppPodIp() {
        return this.prometheusIpService.getHeraAppPodIp();
    }
}

