/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;
import org.nutz.mvc.view.RawView;

public class RawView2
extends RawView {
    protected DataInputStream in;
    protected int maxLen;
    protected String CONTENT_DISPOSITION;

    protected RawView2() {
    }

    public RawView2(String contentType, InputStream in, int maxLen) {
        super(contentType);
        this.in = new DataInputStream(in);
        this.maxLen = maxLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(HttpServletRequest req, HttpServletResponse resp, Object obj) throws Throwable {
        try {
            if (resp.getContentType() == null) {
                resp.setContentType(this.contentType);
            }
            resp.addHeader("Connection", "close");
            String rangeStr = req.getHeader("Range");
            if (!resp.containsHeader("Content-Disposition") && !Strings.isBlank(this.CONTENT_DISPOSITION)) {
                resp.setHeader("Content-Disposition", this.CONTENT_DISPOSITION);
            }
            if (rangeStr == null) {
                resp.setContentLength(this.maxLen);
                Streams.writeAndClose((OutputStream)resp.getOutputStream(), this.in);
                return;
            }
            ArrayList<RawView.RangeRange> rs = new ArrayList<RawView.RangeRange>();
            if (!RawView2.parseRange(rangeStr, rs, this.maxLen)) {
                resp.setStatus(416);
                return;
            }
            long totolSize = 0L;
            for (RawView.RangeRange rangeRange : rs) {
                totolSize += rangeRange.end - rangeRange.start;
            }
            resp.setStatus(206);
            if (rs.size() == 1) {
                RawView.RangeRange rangeRange = (RawView.RangeRange)rs.get(0);
                resp.setHeader("Accept-Ranges", "bytes");
                resp.setHeader("Content-Range", rangeRange.toString(this.maxLen));
                resp.setHeader("Content-Length", "" + totolSize);
                ServletOutputStream out = resp.getOutputStream();
                RawView2.writeDownloadRange(this.in, (OutputStream)out, rangeRange);
            } else {
                String k = R.UU32().substring(0, 11);
                resp.setCharacterEncoding(null);
                resp.setHeader("Content-Type", "multipart/byteranges; boundary=" + k);
                byte[] SLINE = ("--" + k + "\r\n").getBytes();
                byte[] CLINE = ("Content-Type: " + this.contentType + "\r\n").getBytes();
                totolSize += (long)"\r\n".getBytes().length;
                for (RawView.RangeRange rangeRange : rs) {
                    totolSize += (long)SLINE.length;
                    totolSize += (long)CLINE.length;
                    totolSize += (long)("Content-Range: " + rangeRange.toString(this.maxLen) + "\r\n\r\n").getBytes().length;
                    totolSize += (long)"\r\n".getBytes().length;
                }
                resp.setHeader("Content-Length", "" + (totolSize += (long)("--" + k + "--\r\n").getBytes().length));
                RawView.RangeRange preRangeRange = null;
                ServletOutputStream out = resp.getOutputStream();
                out.write("\r\n".getBytes());
                for (RawView.RangeRange rangeRange : rs) {
                    out.write(SLINE);
                    out.write(CLINE);
                    out.write(("Content-Range: " + rangeRange.toString(this.maxLen) + "\r\n\r\n").getBytes());
                    RawView2.writeDownloadRange(this.in, (OutputStream)out, rangeRange, preRangeRange);
                    out.write("\r\n".getBytes());
                    preRangeRange = rangeRange;
                }
                out.write(("--" + k + "--\r\n").getBytes());
            }
        }
        finally {
            Streams.safeClose(this.in);
        }
    }
}

