/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.util.HashMap;
import java.util.Map;
import org.nutz.ioc.Ioc;
import org.nutz.lang.Lang;
import org.nutz.lang.util.Context;
import org.nutz.lang.util.SimpleContext;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.config.AtMap;

public class NutMvcContext
extends SimpleContext {
    private ThreadLocal<Context> reqThreadLocal = new ThreadLocal();
    public Map<String, Ioc> iocs = new HashMap<String, Ioc>();
    public Map<String, AtMap> atMaps = new HashMap<String, AtMap>();
    public Map<String, NutConfig> nutConfigs = new HashMap<String, NutConfig>();
    public Map<String, Map<String, Map<String, Object>>> localizations = new HashMap<String, Map<String, Map<String, Object>>>();

    public Context reqCtx() {
        Context ctx = this.reqThreadLocal.get();
        if (ctx == null) {
            ctx = Lang.context();
            this.reqThreadLocal.set(ctx);
        }
        return ctx;
    }

    public void reqCtx(Context ctx) {
        this.reqThreadLocal.set(ctx);
    }

    public void removeReqCtx() {
        this.reqThreadLocal.remove();
    }

    public void close() {
        this.reqThreadLocal.remove();
        this.iocs.clear();
        this.atMaps.clear();
        this.nutConfigs.clear();
        this.localizations.clear();
    }

    public Ioc getDefaultIoc() {
        if (this.iocs.isEmpty()) {
            return null;
        }
        return this.iocs.values().iterator().next();
    }

    public NutConfig getDefaultNutConfig() {
        if (this.nutConfigs.isEmpty()) {
            return null;
        }
        return this.nutConfigs.values().iterator().next();
    }
}

