/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.Loading;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.UrlMapping;
import org.nutz.mvc.impl.ActionInvoker;

public class ActionHandler {
    private Loading loading;
    private UrlMapping mapping;
    private NutConfig config;

    public ActionHandler(NutConfig config) {
        this.config = config;
        this.loading = config.createLoading();
        this.mapping = this.loading.load(config);
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse resp) {
        ActionContext ac = new ActionContext();
        ac.setRequest(req).setResponse(resp).setServletContext(this.config.getServletContext());
        Mvcs.setActionContext(ac);
        ActionInvoker invoker = this.mapping.get(ac);
        if (null == invoker) {
            return false;
        }
        return invoker.invoke(ac);
    }

    public void depose() {
        this.loading.depose(this.config);
    }
}

