/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.nutz.Nutz;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class ClassTools {
    private static final Log log = Logs.get();
    private static ClassLoader nutClassLoader = Nutz.class.getClassLoader();

    public static String getClassName(InputStream in) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(in));
            HashMap<Integer, String> strs = new HashMap<Integer, String>();
            HashMap<Integer, Integer> classes = new HashMap<Integer, Integer>();
            dis.skipBytes(4);
            dis.skipBytes(2);
            dis.skipBytes(2);
            int constant_pool_count = dis.readUnsignedShort();
            block14: for (int i = 0; i < constant_pool_count - 1; ++i) {
                byte flag = dis.readByte();
                switch (flag) {
                    case 7: {
                        int index = dis.readUnsignedShort();
                        classes.put(i + 1, index);
                        continue block14;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        dis.skipBytes(2);
                        dis.skipBytes(2);
                        continue block14;
                    }
                    case 8: {
                        dis.skipBytes(2);
                        continue block14;
                    }
                    case 3: 
                    case 4: {
                        dis.skipBytes(4);
                        continue block14;
                    }
                    case 5: 
                    case 6: {
                        dis.skipBytes(8);
                        ++i;
                        continue block14;
                    }
                    case 12: {
                        dis.skipBytes(2);
                        dis.skipBytes(2);
                        continue block14;
                    }
                    case 1: {
                        int len = dis.readUnsignedShort();
                        byte[] data = new byte[len];
                        dis.readFully(data);
                        strs.put(i + 1, new String(data, "UTF-8"));
                        continue block14;
                    }
                    case 15: {
                        dis.skipBytes(1);
                        dis.skipBytes(2);
                        continue block14;
                    }
                    case 16: {
                        dis.skipBytes(2);
                        continue block14;
                    }
                    case 18: {
                        dis.skipBytes(2);
                        dis.skipBytes(2);
                        continue block14;
                    }
                    default: {
                        throw new RuntimeException("Impossible!! flag=" + flag);
                    }
                }
            }
            dis.skipBytes(2);
            int pos = dis.readUnsignedShort();
            String name = (String)strs.get(classes.get(pos));
            if (name != null) {
                name = name.replace('/', '.');
            }
            dis.close();
            return name;
        }
        catch (Throwable e) {
            if (log.isInfoEnabled()) {
                log.info("Fail to read ClassName from class InputStream", e);
            }
            return null;
        }
    }

    public static ClassLoader getClassLoader() {
        return nutClassLoader;
    }

    @Deprecated
    public static void setNutClassLoader(ClassLoader nutClassLoader) {
        ClassTools.nutClassLoader = nutClassLoader;
    }

    static {
        if (nutClassLoader == null) {
            try {
                nutClassLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

