/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.entity.LinkVisitor;
import org.nutz.lang.Strings;

public class LinkFieldSet {
    private ArrayList<LinkField> lnks = new ArrayList(3);
    private Map<String, ArrayList<LinkField>> cache = new HashMap<String, ArrayList<LinkField>>();

    void add(LinkField lnk) {
        this.lnks.add(lnk);
    }

    public List<LinkField> getAll() {
        return this.lnks;
    }

    List<LinkField> visit(Object obj, String regex, LinkVisitor visitor) {
        List<LinkField> list = this.getList(regex);
        if (null != visitor) {
            for (LinkField lnk : list) {
                visitor.visit(obj, lnk);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LinkField> getList(String regex) {
        ArrayList<LinkField> list;
        if (Strings.isBlank(regex)) {
            list = this.lnks;
        } else {
            list = this.cache.get(regex);
            if (null == list) {
                Map<String, ArrayList<LinkField>> map = this.cache;
                synchronized (map) {
                    list = this.cache.get(regex);
                    if (null == list) {
                        list = new ArrayList(this.lnks.size());
                        for (LinkField lnk : this.lnks) {
                            if (!Pattern.matches(regex, lnk.getName())) continue;
                            list.add(lnk);
                        }
                        list.trimToSize();
                        this.cache.put(regex, list);
                    }
                }
            }
        }
        return list;
    }
}

