/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.filter;

import com.xiaomi.mone.tpc.login.enums.UserTypeEnum;
import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ozhera.monitor.service.user.LocalUser;
import org.apache.ozhera.monitor.service.user.MoneUserDetailService;
import org.apache.ozhera.monitor.service.user.UseDetailInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;

@Order(value=5)
@WebFilter(filterName="authorizationFilter", urlPatterns={"/*"})
public class AuthorizationFilter
implements Filter {
    public static final String ADMIN_OP_URI_PREFIX = "/api-manual/";
    @Autowired
    MoneUserDetailService moneUserDetailService;

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        List adminUserList;
        AuthUserVo userVo = UserUtil.getUser();
        if (userVo == null || !UserTypeEnum.CAS_TYPE.getCode().equals(userVo.getUserType())) {
            chain.doFilter(request, response);
            return;
        }
        List blackList = this.moneUserDetailService.getBlackList();
        if (blackList.contains(userVo.getAccount())) {
            this.noAuthResponse(response);
            return;
        }
        String url = ((HttpServletRequest)request).getRequestURI();
        if (url.indexOf(ADMIN_OP_URI_PREFIX) >= 0 && !(adminUserList = this.moneUserDetailService.getAdminUserList()).contains(userVo.getAccount())) {
            this.noAuthResponse(response);
            return;
        }
        UseDetailInfo detailInfo = this.moneUserDetailService.queryUser(userVo.getCasUid());
        if (detailInfo == null) {
            chain.doFilter(request, response);
            return;
        }
        List deptBlackList = this.moneUserDetailService.getDeptBlackList();
        if (deptBlackList.contains(detailInfo.getDeptDescr())) {
            List whiteList = this.moneUserDetailService.getWhiteList();
            if (!CollectionUtils.isEmpty((Collection)whiteList) && whiteList.contains(detailInfo.getUserName())) {
                try {
                    LocalUser.set((UseDetailInfo)detailInfo);
                    chain.doFilter(request, response);
                    return;
                }
                finally {
                    LocalUser.clear();
                }
            }
            this.noAuthResponse(response);
            return;
        }
        try {
            LocalUser.set((UseDetailInfo)detailInfo);
            chain.doFilter(request, response);
            return;
        }
        finally {
            LocalUser.clear();
        }
    }

    private void noAuthResponse(ServletResponse response) throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setStatus(401);
    }
}

