/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.ServiceMarketService;
import org.apache.ozhera.monitor.service.model.ServiceMarketQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ServiceMarketController {
    private static final Logger log = LoggerFactory.getLogger(ServiceMarketController.class);
    @Autowired
    ServiceMarketService serviceMarket;

    @PostMapping(value={"/serviceMarket/mimonitor/createMarket"})
    public Result createServiceMarket(HttpServletRequest request, @RequestBody ServiceMarketQuery param) {
        log.info("ServiceMarket.createMarket : {} ", (Object)param);
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getMarketName()) && StringUtils.isNotEmpty((CharSequence)param.getServiceList())) {
            return this.serviceMarket.createMarket(user, param.getMarketName(), param.getBelongTeam(), param.getServiceList(), param.getRemark(), param.getServiceType());
        }
        return Result.fail((ErrorCode)ErrorCode.RequestBodyIsEmpty);
    }

    @GetMapping(value={"/serviceMarket/mimonitor/searchMarket"})
    public Result searchServiceMarket(HttpServletRequest request, Integer primaryId) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (primaryId != null && primaryId != 0) {
            return this.serviceMarket.searchMarket(user, primaryId.intValue());
        }
        return Result.fail((ErrorCode)ErrorCode.ScrapeIdIsEmpty);
    }

    @PostMapping(value={"/serviceMarket/mimonitor/updateMarket"})
    public Result updateServiceMarket(HttpServletRequest request, @RequestBody ServiceMarketQuery param) {
        log.info("ServiceMarket.updateServiceMarket : {} ", (Object)param);
        Integer id = param.getId();
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (id != null && id != 0 && StringUtils.isNotEmpty((CharSequence)param.getMarketName())) {
            return this.serviceMarket.updateMarket(user, id.intValue(), param.getServiceList(), param.getMarketName(), param.getRemark(), param.getBelongTeam(), param.getServiceType().intValue());
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @PostMapping(value={"/serviceMarket/mimonitor/deleteMarket"})
    public Result deleteServiceMarket(HttpServletRequest request, Integer primaryId) {
        log.info("ServiceMarket.deleteServiceMarket id:{} ", (Object)primaryId);
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (primaryId != null && primaryId != 0) {
            return this.serviceMarket.deleteMarket(user, primaryId);
        }
        return Result.fail((ErrorCode)ErrorCode.invalidParamError);
    }

    @GetMapping(value={"/serviceMarket/mimonitor/searchMarketList"})
    public Result searchMarketList(HttpServletRequest request, Integer pageSize, Integer page, String creator, String marketName, String serviceName) {
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (page == 0) {
            page = 1;
        }
        return this.serviceMarket.searchMarketList(user, pageSize.intValue(), page.intValue(), creator, marketName, serviceName);
    }

    @GetMapping(value={"/serviceMarket/mimonitor/getServiceMarketGrafana"})
    public Result getServiceMarketGrafana(HttpServletRequest request, Integer serviceType) {
        log.info("ServiceMarket.getServiceMarketGrafana type: {} ", (Object)serviceType);
        String user = this.checkUser(request);
        if (StringUtils.isEmpty((CharSequence)user)) {
            return Result.fail((ErrorCode)ErrorCode.ThisUserNotHaveAuth);
        }
        if (serviceType == null || serviceType < 0) {
            return Result.fail((ErrorCode)ErrorCode.RequestBodyIsEmpty);
        }
        String url = this.serviceMarket.getServiceMarketGrafana(serviceType);
        return Result.success((Object)url);
    }

    public String checkUser(HttpServletRequest request) {
        AuthUserVo userInfo = UserUtil.getUser();
        if (userInfo == null) {
            return "";
        }
        return userInfo.genFullAccount();
    }
}

