/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import com.xiaomi.mone.tpc.login.util.UserUtil;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateInfo;
import org.apache.ozhera.monitor.bo.RulePromQLTemplateParam;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.RulePromQLTemplateService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/promql/template"})
public class RulePromQLTemplateController {
    private static final Logger log = LoggerFactory.getLogger(RulePromQLTemplateController.class);
    @Autowired
    private RulePromQLTemplateService rulePromQLTemplateService;

    @RequestMapping(value={"/add"})
    public Result add(HttpServletRequest request, @RequestBody RulePromQLTemplateParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("RulePromQLTemplateController.add param : {} ", (Object)param);
            if (StringUtils.isBlank((CharSequence)param.getName()) || StringUtils.isBlank((CharSequence)param.getPromql())) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("RulePromQLTemplateController.add request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("RulePromQLTemplateController.add param : {} ,user : {}", (Object)param, (Object)user);
            return this.rulePromQLTemplateService.add(user, param);
        }
        catch (Exception e) {
            log.error("RulePromQLTemplateController.add exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/edit"})
    public Result edit(HttpServletRequest request, @RequestBody RulePromQLTemplateParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("RulePromQLTemplateController.edit param : {} ", (Object)param);
            if (StringUtils.isBlank((CharSequence)param.getName()) || StringUtils.isBlank((CharSequence)param.getPromql()) || param.getId() <= 0) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("RulePromQLTemplateController.edit request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("RulePromQLTemplateController.edit param : {} ,user : {}", (Object)param, (Object)user);
            return this.rulePromQLTemplateService.edit(user, param);
        }
        catch (Exception e) {
            log.error("RulePromQLTemplateController.edit exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/deleteById"})
    public Result deleteById(HttpServletRequest request, @RequestBody RulePromQLTemplateParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("RulePromQLTemplateController.deleteById param : {} ", (Object)param);
            if (param.getId() <= 0) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("RulePromQLTemplateController.deleteById request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("RulePromQLTemplateController.deleteById param : {} ,user : {}", (Object)param, (Object)user);
            return this.rulePromQLTemplateService.deleteById(user, Integer.valueOf(param.getId()));
        }
        catch (Exception e) {
            log.error("RulePromQLTemplateController.deleteById exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/search"})
    public Result<PageData<List<RulePromQLTemplateInfo>>> search(HttpServletRequest request, @RequestBody RulePromQLTemplateParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.search param : {} ", (Object)param);
            param.pageQryInit();
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.search request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.search param : {} ,user : {}", (Object)param, (Object)user);
            return this.rulePromQLTemplateService.search(user, param);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.search exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @RequestMapping(value={"/test_promql"})
    public Result<String> testPromQL(HttpServletRequest request, @RequestBody RulePromQLTemplateParam param) {
        AuthUserVo userInfo = null;
        try {
            log.info("AlarmStrategyController.testPromQL param : {} ", (Object)param);
            if (StringUtils.isBlank((CharSequence)param.getPromql())) {
                return Result.fail((ErrorCode)ErrorCode.invalidParamError);
            }
            userInfo = UserUtil.getUser();
            if (userInfo == null) {
                log.info("AlarmStrategyController.testPromQL request info error no user info found! param : {} ", (Object)param);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            String user = userInfo.genFullAccount();
            log.info("AlarmStrategyController.testPromQL param : {} ,user : {}", (Object)param, (Object)user);
            return this.rulePromQLTemplateService.testPromQL(user, param);
        }
        catch (Exception e) {
            log.error("AlarmStrategyController.testPromQL exception! param : {} ,userInfo :{}", new Object[]{param, userInfo, e});
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

