/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.service.prometheus;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ozhera.prometheus.agent.Impl.RuleAlertDao;
import org.apache.ozhera.prometheus.agent.Impl.SilenceDao;
import org.apache.ozhera.prometheus.agent.entity.RuleSilenceEntity;
import org.apache.ozhera.prometheus.agent.enums.ErrorCode;
import org.apache.ozhera.prometheus.agent.enums.RuleSilenceStatusEnum;
import org.apache.ozhera.prometheus.agent.param.alert.AMSilence;
import org.apache.ozhera.prometheus.agent.param.alert.AMSilenceResponse;
import org.apache.ozhera.prometheus.agent.param.alert.Matcher;
import org.apache.ozhera.prometheus.agent.param.alert.RuleSilenceParam;
import org.apache.ozhera.prometheus.agent.result.Result;
import org.apache.ozhera.prometheus.agent.service.alarmContact.DingAlertContact;
import org.apache.ozhera.prometheus.agent.service.dto.SilenceAlertManagerReqBuilder;
import org.apache.ozhera.prometheus.agent.util.DateUtil;
import org.apache.ozhera.prometheus.agent.util.Http;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RuleSilenceService {
    private static final Logger log = LoggerFactory.getLogger(RuleSilenceService.class);
    @Autowired
    RuleAlertDao ruleAlertDao;
    @NacosValue(value="${job.alertManager.Addr}", autoRefreshed=true)
    private String alertManagerAddr;
    @NacosValue(value="${hera.alert.type}", autoRefreshed=true)
    private String alertTYPE;
    @Autowired(required=false)
    DingAlertContact dingAlertContact;
    @Autowired
    SilenceDao dao;
    private static final String CLUSTER = "open-source";
    private final Gson gson = new Gson();
    private final Date endTime = new Date();
    public static final String CREATE_SILENCE = "/api/v2/silences";

    public Result createRuleSilence(SilenceAlertManagerReqBuilder param) {
        List<Matcher> matcherList = this.buildMatchers(param);
        if (matcherList.isEmpty()) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        RuleSilenceParam reqDto = new RuleSilenceParam();
        reqDto.setComment("Hera silence");
        reqDto.setCreatedBy(param.getUserId());
        reqDto.setMatcher(matcherList);
        String silenceResId = this.AddSilence(reqDto, param.getExpectedSilenceTime());
        log.info("request alertManager Res: {}", (Object)silenceResId);
        if (silenceResId == null) {
            log.error("createRuleSilence request alertManager failed,param:{}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.OperationFailed);
        }
        RuleSilenceEntity entity = new RuleSilenceEntity();
        entity.setUuid(silenceResId);
        entity.setPromCluster(CLUSTER);
        entity.setStatus(RuleSilenceStatusEnum.SUCCESS.getDesc());
        entity.setAlertId(param.getAlertName());
        entity.setStartTime(new Date());
        this.endTime.setTime(System.currentTimeMillis() + this.transferTimeMillis(param.getExpectedSilenceTime()));
        entity.setEndTime(this.endTime);
        entity.setCreatedTime(new Date());
        entity.setUpdatedTime(new Date());
        entity.setComment("Hera silence");
        entity.setCreatedBy(param.getUserId());
        log.info("createRuleSilence insert db begin,entity:{}", (Object)entity);
        Long silenceDbId = this.dao.CreateSilence(entity);
        if (silenceDbId == null) {
            log.error("createRuleSilence insert db failed,entity:{}", (Object)entity);
            return Result.fail((ErrorCode)ErrorCode.OperationFailed);
        }
        this.updateCardByAlertType(param.getUserId(), param.getContent(), param.getExpectedSilenceTime(), param.getOutTrackId(), param.getCallbackTitle());
        return Result.success((Object)"ok");
    }

    private List<Matcher> buildMatchers(SilenceAlertManagerReqBuilder param) {
        final Matcher matcherApplication = new Matcher();
        matcherApplication.setName("application");
        matcherApplication.setValue(param.getApplication());
        matcherApplication.setEqual(true);
        matcherApplication.setRegex(false);
        final Matcher matcherAlertName = new Matcher();
        matcherAlertName.setName("alertname");
        matcherAlertName.setValue(param.getAlertName());
        matcherAlertName.setEqual(true);
        matcherAlertName.setRegex(false);
        return new ArrayList<Matcher>(){
            {
                this.add(matcherApplication);
                this.add(matcherAlertName);
            }
        };
    }

    private String ValidateTime(long startTime, long endTime) {
        Timestamp sTimeStamp = new Timestamp(startTime);
        Timestamp eTimeStamp = new Timestamp(endTime);
        Timestamp nowTimeStamp = new Timestamp(System.currentTimeMillis() / 1000L);
        if (sTimeStamp.equals(0) || eTimeStamp.equals(0)) {
            return "invalid zero start timestamp ro end timestamp";
        }
        if (eTimeStamp.before(nowTimeStamp)) {
            return "end time can not be in the past";
        }
        if (eTimeStamp.before(sTimeStamp)) {
            return "end time must not be before start time";
        }
        return "";
    }

    private String AddSilence(RuleSilenceParam silence, String expectedSilenceTime) {
        String requestPath = this.alertManagerAddr + CREATE_SILENCE;
        AMSilence amSilence = this.convertToAMSilence(silence, expectedSilenceTime);
        String amSilenceStr = this.gson.toJson((Object)amSilence);
        String response = Http.innerRequestResponseData((String)amSilenceStr, (String)requestPath, (String)"POST");
        AMSilenceResponse amSilenceResponse = (AMSilenceResponse)this.gson.fromJson(response, AMSilenceResponse.class);
        String silenceId = amSilenceResponse.getSilenceID();
        return silenceId;
    }

    private AMSilence convertToAMSilence(RuleSilenceParam silence, String expectedSilenceTime) {
        long expectedSilenceMillis = this.transferTimeMillis(expectedSilenceTime);
        AMSilence amSilence = new AMSilence();
        amSilence.setComment(silence.getComment());
        amSilence.setMatchers(silence.getMatcher());
        amSilence.setCreatedBy(silence.getCreatedBy());
        amSilence.setStartsAt(DateUtil.TimeStampToISO8601UTC((long)System.currentTimeMillis()));
        amSilence.setEndsAt(DateUtil.TimeStampToISO8601UTC((long)(System.currentTimeMillis() + expectedSilenceMillis)));
        return amSilence;
    }

    private long transferTimeMillis(String expectedSilenceTime) {
        switch (expectedSilenceTime) {
            case "2h": {
                return 0x6DDD00L;
            }
            case "1d": {
                return 86400000L;
            }
            case "3d": {
                return 259200000L;
            }
        }
        return 0x6DDD00L;
    }

    private void updateCardByAlertType(String userId, String content, String expectedSilenceTime, String carBizId, String callbackTitle) {
        switch (this.alertTYPE) {
            case "dingding": {
                this.dingAlertContact.updateDingDingCard(userId, content, expectedSilenceTime, carBizId, callbackTitle);
                break;
            }
            case "feishu": {
                break;
            }
            case "email": {
                break;
            }
        }
    }
}

