/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.common;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.xiaomi.youpin.docean.adapter.DoubleDefaultAdapter;
import com.xiaomi.youpin.docean.adapter.IntegerDefaultAdapter;
import com.xiaomi.youpin.docean.adapter.LongDefaultAdapter;
import com.xiaomi.youpin.docean.common.DefaultInvokeMethodCallback;
import com.xiaomi.youpin.docean.common.ExceptionUtils;
import com.xiaomi.youpin.docean.common.InvokeMethodCallback;
import com.xiaomi.youpin.docean.common.MethodReq;
import com.xiaomi.youpin.docean.exception.DoceanException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);
    private static ConcurrentHashMap<String, FastMethod> methodCache = new ConcurrentHashMap();

    public static Field[] fields(Class clazz) {
        Class superClazz = clazz.getSuperclass();
        Field[] superFields = new Field[]{};
        if (superClazz != null && !superClazz.equals(Object.class)) {
            superFields = superClazz.getDeclaredFields();
        }
        Field[] fields = clazz.getDeclaredFields();
        Field[] allFields = new Field[fields.length + superFields.length];
        System.arraycopy(superFields, 0, allFields, 0, superFields.length);
        System.arraycopy(fields, 0, allFields, superFields.length, fields.length);
        return allFields;
    }

    public static void setField(Object obj, Field field, Object val) {
        field.setAccessible(true);
        try {
            field.set(obj, val);
        }
        catch (IllegalAccessException e) {
            throw new DoceanException(e);
        }
    }

    public static <T> T getField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new DoceanException(e);
        }
    }

    public static <T> T getSupperClassField(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getSuperclass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new DoceanException(e);
        }
    }

    public static Object invokeMethod(Object obj, Class clazz, String methodName, Object[] params) {
        try {
            Optional<Method> optional = ReflectUtils.getMethod(clazz, methodName, params.length);
            if (optional.isPresent()) {
                optional.get().setAccessible(true);
                if (optional.get().getParameterCount() != params.length) {
                    return null;
                }
                if (params.length == 0) {
                    return optional.get().invoke(obj, new Object[0]);
                }
                return optional.get().invoke(obj, params);
            }
        }
        catch (Throwable ex) {
            log.error("invokeMethod error:{} class:{} method:{}", new Object[]{ex.getMessage(), clazz.getName(), methodName});
        }
        return null;
    }

    public static Object invokeFastMethod(Object obj, Class clazz, String methodName, Object[] params) {
        try {
            String key = String.valueOf(clazz) + "_" + methodName;
            FastMethod m = methodCache.get(key);
            if (null != m) {
                return m.invoke(obj, params);
            }
            Optional<Method> optional = ReflectUtils.getMethod(clazz, methodName);
            if (optional.isPresent()) {
                FastClass fastClass = FastClass.create((Class)clazz);
                FastMethod method = fastClass.getMethod(optional.get());
                methodCache.putIfAbsent(key, method);
                return method.invoke(obj, params);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
        return null;
    }

    public static Object invokeFastMethod(Object obj, Class clazz, String[] types, String methodName, Object[] params) {
        DefaultInvokeMethodCallback callback = new DefaultInvokeMethodCallback();
        return ReflectUtils.invokeFastMethod0(Maps.newHashMap(), obj, clazz, types, methodName, params, callback);
    }

    public static Object invokeFastMethod0(Map<String, String> attachments, Object obj, Class clazz, String[] types, String methodName, Object[] params, InvokeMethodCallback callback) {
        try {
            FastMethod m;
            String key = String.valueOf(clazz) + "_" + methodName;
            if (null != types && types.length > 0) {
                key = key + "_" + Arrays.stream(types).collect(Collectors.joining("_"));
            }
            if (null != (m = methodCache.get(key))) {
                Object res = callback.fastInvoke(m, obj, params);
                return res;
            }
            Optional<Method> optional = ReflectUtils.getMethod2(clazz, types, methodName);
            if (optional.isPresent()) {
                FastClass fastClass = FastClass.create((Class)clazz);
                FastMethod method = fastClass.getMethod(optional.get());
                methodCache.putIfAbsent(key, method);
                Object res = callback.fastInvoke(method, obj, params);
                return res;
            }
            throw new RuntimeException("function not found:" + methodName);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static Object invokeMethod(Object obj, Method method, Object[] params) {
        try {
            if (params.length == 0) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public static Object invokeFastMethod(Object obj, Method method, Object[] params) {
        try {
            String key = String.valueOf(obj.getClass()) + "_" + method.getName();
            FastMethod m = methodCache.get(key);
            if (null != m) {
                return m.invoke(obj, params);
            }
            FastClass fc = FastClass.create(obj.getClass());
            FastMethod fm = fc.getMethod(method);
            methodCache.putIfAbsent(key, fm);
            return fm.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public static Object invokeMethod(Object obj, String methodName, Object[] params) {
        try {
            Method method = obj.getClass().getMethod(methodName, (Class[])Arrays.stream(params).map(it -> it.getClass()).toArray(Class[]::new));
            if (params.length == 0) {
                return method.invoke(obj, new Object[0]);
            }
            return method.invoke(obj, params);
        }
        catch (Throwable ex) {
            log.error(ex.getMessage());
            throw new DoceanException(ex);
        }
    }

    public static Optional<Method> getMethod(Class clazz, String methodName) {
        return Arrays.stream(clazz.getMethods()).filter(it -> it.getName().equals(methodName)).findAny();
    }

    public static Optional<Method> getMethod2(Class clazz, String[] types, String methodName) {
        return Arrays.stream(clazz.getMethods()).filter(it -> {
            if (it.getName().equals(methodName)) {
                Class<?>[] ptypes = it.getParameterTypes();
                if (ptypes.length == types.length) {
                    boolean tmp = true;
                    for (int i = 0; i < types.length; ++i) {
                        if (ptypes[i].getName().equals(types[i])) continue;
                        tmp = false;
                        break;
                    }
                    return tmp;
                }
                return false;
            }
            return false;
        }).findAny();
    }

    public static Optional<Method> getMethod(Class clazz, String methodName, int paramNum) {
        return Arrays.stream(clazz.getMethods()).filter(it -> it.getName().equals(methodName) && it.getParameterCount() == paramNum).findAny();
    }

    public static Object[] getMethodParams(Object obj, String methodName, JsonElement params) {
        Method method = ReflectUtils.getMethod(obj.getClass(), methodName).get();
        return ReflectUtils.getMethodParams(method, params);
    }

    public static Object[] getMethodParams(Method method, List<String> params) {
        Gson gson = new Gson();
        Class[] types = method.getParameterTypes();
        if (types.length == 0) {
            return new Object[0];
        }
        return IntStream.range(0, params.size()).mapToObj(i -> gson.fromJson((String)params.get(i), types[i])).collect(Collectors.toList()).toArray();
    }

    public static Object[] getMethodParams(Method method, JsonElement params) {
        Gson gson = new GsonBuilder().registerTypeAdapter(Integer.class, (Object)new IntegerDefaultAdapter()).registerTypeAdapter(Double.class, (Object)new DoubleDefaultAdapter()).registerTypeAdapter(Long.class, (Object)new LongDefaultAdapter()).create();
        Class[] types = method.getParameterTypes();
        if (types.length == 0) {
            return new Object[0];
        }
        if (params.isJsonObject()) {
            return Stream.of(gson.fromJson(gson.toJson(params), types[0])).toArray();
        }
        if (params.isJsonArray()) {
            JsonArray array = params.getAsJsonArray();
            return IntStream.range(0, types.length).mapToObj(i -> gson.fromJson(gson.toJson(array.get(i)), types[i])).collect(Collectors.toList()).toArray();
        }
        throw new DoceanException();
    }

    public static Class classForName(String name) {
        if (name.equals("com.xiaomi.youpin.docean.Mvc$LazyHolder")) {
            return null;
        }
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            log.error("classForName:{} error:{}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static Class classForName(String name, ClassLoader classLoader) {
        if (name.equals("com.xiaomi.youpin.docean.Mvc$LazyHolder")) {
            return null;
        }
        try {
            if (null == classLoader) {
                return Class.forName(name);
            }
            return Class.forName(name, true, classLoader);
        }
        catch (Throwable e) {
            log.error("classForName:{} error:{}", (Object)name, (Object)e.getMessage());
            return null;
        }
    }

    public static Object getInstance(Class clazz) {
        try {
            if (clazz.isInterface()) {
                return null;
            }
            Constructor constructor = clazz.getConstructor(new Class[0]);
            if (null != constructor) {
                return clazz.newInstance();
            }
        }
        catch (InstantiationException e) {
            log.error(e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static Optional<Annotation> getAnno(Class<?> clazz, List<Class<? extends Annotation>> list) {
        Annotation[] anns = clazz.getAnnotations();
        return Arrays.stream(anns).filter(a -> list.stream().filter(it -> a.annotationType().equals(it)).findAny().isPresent()).findAny();
    }

    public static Object invokeMethod(MethodReq req, Object obj, BiFunction<Class[], byte[][], Object[]> fun) {
        return ReflectUtils.invokeMethod(req.getMethodName(), obj, req.getParamTypes(), req.getByteParams(), fun, true);
    }

    public static Object invokeMethod(MethodReq req, Object obj, BiFunction<Class[], byte[][], Object[]> fun, InvokeMethodCallback callback) {
        return ReflectUtils.invokeMethod0(req.getAttachments(), req.getMethodName(), obj, req.getParamTypes(), req.getByteParams(), fun, true, callback);
    }

    public static Object invokeMethod(String methodName, Object obj, String[] types, byte[][] paramArray, BiFunction<Class[], byte[][], Object[]> fun, boolean fast) {
        return ReflectUtils.invokeMethod0(Maps.newHashMap(), methodName, obj, types, paramArray, fun, fast, null);
    }

    public static Object invokeMethod0(Map<String, String> attachments, String methodName, Object obj, String[] types, byte[][] paramArray, BiFunction<Class[], byte[][], Object[]> fun, boolean fast, InvokeMethodCallback callback) {
        if (null == callback) {
            callback = new DefaultInvokeMethodCallback();
        }
        try {
            if (types.length > 0) {
                Class[] clazzArray = (Class[])Arrays.stream(types).map(i -> {
                    if (i.equals("int")) {
                        return Integer.TYPE;
                    }
                    if (i.equals("long")) {
                        return Long.TYPE;
                    }
                    if (i.equals("double")) {
                        return Double.TYPE;
                    }
                    if (i.equals("byte")) {
                        return Byte.TYPE;
                    }
                    if (i.equals("short")) {
                        return Short.TYPE;
                    }
                    if (i.equals("float")) {
                        return Float.TYPE;
                    }
                    if (i.equals("boolean")) {
                        return Boolean.TYPE;
                    }
                    try {
                        return Class.forName(i);
                    }
                    catch (ClassNotFoundException e) {
                        throw new DoceanException("class forName error:" + e.getMessage());
                    }
                }).toArray(Class[]::new);
                Object[] params = fun.apply(clazzArray, paramArray);
                if (fast) {
                    return ReflectUtils.invokeFastMethod0(attachments, obj, obj.getClass(), types, methodName, params, callback);
                }
                Method method = obj.getClass().getMethod(methodName, clazzArray);
                Object res = callback.invoke(method, obj, params);
                return res;
            }
            Method method = obj.getClass().getMethod(methodName, new Class[0]);
            Object res = callback.invoke(method, obj, null);
            return res;
        }
        catch (Throwable ex) {
            throw ExceptionUtils.getRuntimeException(ex);
        }
    }

    public static void clear() {
        methodCache.clear();
    }
}

