/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongDefaultAdapter
implements JsonSerializer<Long>,
JsonDeserializer<Long> {
    private static final Logger log = LoggerFactory.getLogger(LongDefaultAdapter.class);
    private Gson gson = new Gson();

    public Long deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsString().equals("")) {
            return null;
        }
        try {
            return json.getAsLong();
        }
        catch (NumberFormatException e) {
            log.error("Long LongDefaultAdapter error,param:{}", (Object)this.gson.toJson(json), (Object)e);
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    public JsonElement serialize(Long src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive((Number)src);
    }
}

