/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.readwrite.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.s7.events.S7AlarmEvent;
import org.apache.plc4x.java.s7.events.S7ModeEvent;
import org.apache.plc4x.java.s7.events.S7SysEvent;
import org.apache.plc4x.java.s7.readwrite.DataTransportErrorCode;
import org.apache.plc4x.java.s7.readwrite.DataTransportSize;
import org.apache.plc4x.java.s7.readwrite.ModeTransitionType;
import org.apache.plc4x.java.s7.utils.S7DiagnosticEventId;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcDATE;
import org.apache.plc4x.java.spi.values.PlcTIME;
import org.json.JSONArray;
import org.json.JSONObject;

public class StaticHelper {
    private static final LocalDate siemensEpoch = LocalDate.of(1990, 1, 1);
    private static final int daysBetweenUnixAndSiemensEpoch = (int)ChronoUnit.DAYS.between(LocalDate.EPOCH, siemensEpoch);

    public static Long s5TimeToDuration(Short data) {
        long tb;
        short t = data;
        long tv = (short)((t & 0xF) + ((t & 0xF0) >> 4) * 10 + ((t & 0xF00) >> 8) * 100);
        long totalms = tv * (tb = (long)((short)(10.0 * Math.pow(10.0, (t & 0xF000) >> 12))));
        return totalms <= 9990000L ? totalms : 9990000L;
    }

    public static Short durationToS5Time(Duration duration) {
        short tv = 0;
        int tb = 0;
        short s5time = 0;
        long totalms = duration.toMillis();
        if (totalms >= 0L && totalms <= 9990000L) {
            if (totalms <= 9990L) {
                tb = 0;
                tv = (short)(totalms / 10L);
            } else if (totalms <= 99900L) {
                tb = 1;
                tv = (short)(totalms / 100L);
            } else if (totalms <= 999000L) {
                tb = 2;
                tv = (short)(totalms / 1000L);
            } else if (totalms > 999000L) {
                tb = 3;
                tv = (short)(totalms / 10000L);
            }
            short uni = (short)(tv % 10);
            short dec = (short)(tv / 10 % 10);
            short cen = (short)(tv / 100 % 10);
            return (short)(tb << 12 | cen << 8 | dec << 4 | uni);
        }
        return s5time;
    }

    public static Duration s7TimeToDuration(Integer data) {
        Duration res = Duration.ZERO;
        if (data >= 0) {
            res = res.plusMillis(data.intValue());
        } else {
            long ms = Integer.MIN_VALUE - (data & Integer.MIN_VALUE);
            res = res.minusMillis(data.intValue());
        }
        return res;
    }

    public static Integer durationToS7Time(Duration data) {
        Integer res = 0;
        res = data.isNegative() ? Integer.valueOf((int)data.toMillis() + Integer.MIN_VALUE) : Integer.valueOf((int)data.toMillis());
        return res;
    }

    public static LocalTime s7TodToLocalTime(Integer data) {
        if (data > 86399999) {
            data = 86399999;
        }
        if (data < 0) {
            data = 0;
        }
        return LocalTime.MIDNIGHT.plusNanos((long)data.intValue() * 1000000L);
    }

    public static Integer localTimeToS7Tod(LocalTime data) {
        return (int)(data.toNanoOfDay() / 1000000L);
    }

    public static LocalDate s7DateToLocalDate(Short data) {
        LocalDate res = LocalDate.of(1990, 1, 1);
        res = res.plusDays(data.shortValue());
        return res;
    }

    public static Short localDateToS7Date(LocalDate data) {
        LocalDate ini = LocalDate.of(1990, 1, 1);
        long resl = ChronoUnit.DAYS.between(ini, data);
        return (short)resl;
    }

    public static LocalDateTime s7DateTimeToLocalDateTime(ByteBuf data) {
        int year = StaticHelper.bcdToInt(data.readByte());
        int month = StaticHelper.bcdToInt(data.readByte());
        int day = StaticHelper.bcdToInt(data.readByte());
        int hour = StaticHelper.bcdToInt(data.readByte());
        int minute = StaticHelper.bcdToInt(data.readByte());
        int second = StaticHelper.bcdToInt(data.readByte());
        int millih = StaticHelper.bcdToInt(data.readByte()) * 10;
        int milll = data.readByte() >> 4;
        int milliseconds = millih + milll;
        int nanoseconds = milliseconds * 1000000;
        year = year >= 90 ? (year += 1900) : (year += 2000);
        return LocalDateTime.of(year, month, day, hour, minute, second, nanoseconds);
    }

    public static LocalDateTime s7DateAndTimeToLocalDateTime(int year, int month, int day, int hour, int min, int sec, int msec) {
        int nanoseconds = msec * 1000000;
        year = year >= 90 ? (year += 1900) : (year += 2000);
        return LocalDateTime.of(year, month, day, hour, min, sec, nanoseconds);
    }

    public static byte[] localDateTimeToS7DateTime(LocalDateTime data) {
        byte[] res = new byte[8];
        res[0] = StaticHelper.byteToBcd(data.getYear() % 100);
        res[1] = StaticHelper.byteToBcd(data.getMonthValue());
        res[2] = StaticHelper.byteToBcd(data.getDayOfMonth());
        res[3] = StaticHelper.byteToBcd(data.getHour());
        res[4] = StaticHelper.byteToBcd(data.getMinute());
        res[5] = StaticHelper.byteToBcd(data.getSecond());
        long ms = data.getNano() / 1000000;
        res[6] = (byte)(ms / 100L << 4 | ms / 10L % 10L);
        byte dayofweek = (byte)(data.getDayOfWeek().getValue() < 7 ? data.getDayOfWeek().getValue() + 1 : 1);
        res[7] = (byte)(ms % 10L << 4 | (long)dayofweek);
        return res;
    }

    private static byte byteToBcd(int incomingByte) {
        byte dec = (byte)(incomingByte / 10 % 10);
        return (byte)(dec << 4 | incomingByte % 10);
    }

    private static int bcdToInt(byte bcd) {
        return (bcd >> 4) * 10 + (bcd & 0xF);
    }

    public static void byteToBcd(WriteBuffer buffer, short _value) throws SerializationException {
        short incomingByte = _value;
        byte outputByte = 0;
        byte dec = (byte)(incomingByte / 10 % 10);
        outputByte = (byte)(dec << 4 | incomingByte % 10);
        buffer.writeByte(outputByte, new WithWriterArgs[0]);
    }

    public static int bcdToInt(ReadBuffer buffer) throws ParseException {
        byte bcd = buffer.readByte(new WithReaderArgs[0]);
        return (bcd >> 4) * 10 + (bcd & 0xF);
    }

    public static int s7msecToInt(ReadBuffer buffer) throws ParseException {
        int centenas = StaticHelper.bcdToInt(buffer.readUnsignedByte(4, new WithReaderArgs[0]));
        int decenas = StaticHelper.bcdToInt(buffer.readUnsignedByte(4, new WithReaderArgs[0]));
        int unidad = StaticHelper.bcdToInt(buffer.readUnsignedByte(4, new WithReaderArgs[0]));
        return centenas * 100 + decenas * 10 + unidad;
    }

    public static void intToS7msec(WriteBuffer buffer, int _value) throws SerializationException {
        int local = 0;
        local = _value > 999 ? 999 : _value;
        int centenas = local / 100;
        int residual = local - centenas * 100;
        int decenas = residual / 10;
        int unidad = residual - decenas * 10;
        buffer.writeUnsignedByte(4, (byte)centenas, new WithWriterArgs[0]);
        buffer.writeUnsignedByte(4, (byte)decenas, new WithWriterArgs[0]);
        buffer.writeUnsignedByte(4, (byte)unidad, new WithWriterArgs[0]);
    }

    public static void leftShift3(WriteBuffer buffer, int _value) throws SerializationException {
        int valor = _value << 3;
        buffer.writeUnsignedInt(16, valor, new WithWriterArgs[0]);
    }

    public static int rightShift3(ReadBuffer buffer) throws ParseException {
        return buffer.readUnsignedInt(16, new WithReaderArgs[0]) >> 3;
    }

    public static int rightShift3(ReadBuffer buffer, DataTransportSize tsize) throws ParseException {
        int value = 0;
        value = tsize == DataTransportSize.OCTET_STRING || tsize == DataTransportSize.REAL ? buffer.readUnsignedInt(16, new WithReaderArgs[0]) : buffer.readUnsignedInt(16, new WithReaderArgs[0]) >> 3;
        return value;
    }

    public static int eventItemLength(ReadBuffer buffer, int valueLength) {
        return valueLength % 2 == 0 || !buffer.hasMore((valueLength + 1) * 8) ? valueLength : valueLength + 1;
    }

    public static PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case NOT_FOUND: {
                return PlcResponseCode.NOT_FOUND;
            }
            case INVALID_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
            case ACCESS_DENIED: {
                return PlcResponseCode.ACCESS_DENIED;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private static byte[] wordToBytes(long data) {
        return new byte[]{(byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    private static byte[] dwordToBytes(long data) {
        return new byte[]{(byte)(data >> 24 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 0 & 0xFFL)};
    }

    public static String modeEventProcessing(S7ModeEvent mode) {
        StringBuilder sb = new StringBuilder("CPU is in : ");
        if (ModeTransitionType.isDefined((Short)mode.getMap().get("CURRENT_MODE")).booleanValue()) {
            short currentmode = (Short)mode.getMap().get("CURRENT_MODE");
            sb.append(ModeTransitionType.enumForValue(currentmode).name());
        } else {
            sb.append("UNDEFINED");
        }
        return sb.toString();
    }

    public static String sysEventProcessing(S7SysEvent event, String eventtext, HashMap<String, HashMap<String, String>> textlists) {
        Pattern EVENT_SIG = Pattern.compile("(@[\\d]{0,3}[bycwixdrBYCWIXDR](%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@)");
        Pattern FIELDS = Pattern.compile("@(?<sig>[\\d]{0,3})(?<type>[bycwixdrBYCWIXDR])(?<format>%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@");
        Pattern FIELD_FORMAT = Pattern.compile("%([\\d]{0,2})([duxbsDUXBS]{1})");
        Map<String, Object> map = event.getMap();
        Matcher matcher = EVENT_SIG.matcher(eventtext);
        Matcher fields = null;
        Matcher fieldformat = null;
        Object strSig = null;
        ByteBuf bytebuf = null;
        int length = 0;
        int sig = 0;
        long value = 0L;
        String strOut = eventtext;
        String strField = null;
        block20: while (matcher.find()) {
            fields = FIELDS.matcher(matcher.group(0));
            if (!fields.find()) break;
            int n = sig = fields.group(1) == "" ? 1 : Integer.parseInt(fields.group(1));
            if (sig == 0 || sig > 2) break;
            String infofield = sig == 1 ? "INFO1" : "INFO2";
            long infovalue = (Long)event.getMap().get(infofield);
            String format = fields.group(3).toUpperCase();
            bytebuf = sig == 1 ? Unpooled.wrappedBuffer((byte[])StaticHelper.wordToBytes(infovalue)) : Unpooled.wrappedBuffer((byte[])StaticHelper.dwordToBytes(infovalue));
            switch (fields.group(2).toUpperCase()) {
                case "B": {
                    if (bytebuf.capacity() < 1) continue block20;
                    strField = String.valueOf(bytebuf.getBoolean(0));
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "Y": {
                    String strReplace;
                    if (bytebuf.capacity() < 1) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedByte(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedByte(0);
                        strField = Integer.toBinaryString((byte)value);
                    } else {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "C": {
                    if (!format.contains("%T#")) {
                        if (bytebuf.capacity() < 1) continue block20;
                        fieldformat = FIELD_FORMAT.matcher(format);
                        if (fieldformat.find()) {
                            length = Integer.parseInt(fieldformat.group(1));
                            length = length > bytebuf.capacity() ? bytebuf.capacity() : length;
                            strField = bytebuf.readCharSequence(length, Charset.forName("utf-8")).toString();
                        }
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "W": {
                    String strReplace;
                    if (bytebuf.capacity() < 2) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedShort(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedShort(0);
                        strField = Integer.toBinaryString((short)value);
                    } else {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "I": {
                    String strReplace;
                    if (bytebuf.capacity() < 4) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "X": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "D": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "R": {
                    if (bytebuf.capacity() < 4 || !format.contains("F")) continue block20;
                    strField = String.format(format, value);
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                }
            }
        }
        return strOut;
    }

    public static String alarmProcessing(S7AlarmEvent alarm, String alarmText, HashMap<String, HashMap<String, String>> textlists) {
        Pattern ALARM_SIG = Pattern.compile("(@[\\d]{0,3}[bycwixdrBYCWIXDR](%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@)");
        Pattern FIELDS = Pattern.compile("@(?<sig>[\\d]{0,3})(?<type>[bycwixdrBYCWIXDR])(?<format>%([\\d]{0,2}[duxbs]){1}|(\\d\\.\\df){1}|(t#[a-zA-Z0-9]+){1})@");
        Pattern FIELD_FORMAT = Pattern.compile("%([\\d]{0,2})([duxbsDUXBS]{1})");
        Map<String, Object> map = alarm.getMap();
        Matcher matcher = ALARM_SIG.matcher(alarmText);
        Matcher fields = null;
        Matcher fieldformat = null;
        String strSig = null;
        ByteBuf bytebuf = null;
        int length = 0;
        int sig = 0;
        long value = 0L;
        String strOut = new String(alarmText);
        String strField = null;
        block20: while (matcher.find()) {
            fields = FIELDS.matcher(matcher.group(0));
            if (!fields.find()) break;
            sig = fields.group(1) == "" ? 1 : Integer.parseInt(fields.group(1));
            strSig = "SIG_" + sig + "_DATA";
            if ((Short)map.get("ASSOCIATED_VALUES") == 0 || sig > (Short)map.get("ASSOCIATED_VALUES")) break;
            bytebuf = Unpooled.wrappedBuffer((byte[])((byte[])map.get(strSig)));
            String format = fields.group(3).toUpperCase();
            switch (fields.group(2).toUpperCase()) {
                case "B": {
                    if (bytebuf.capacity() < 1) continue block20;
                    strField = String.valueOf(bytebuf.getBoolean(0));
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "Y": {
                    String strReplace;
                    if (bytebuf.capacity() < 1) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedByte(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedByte(0);
                        strField = Integer.toBinaryString((byte)value);
                    } else {
                        value = bytebuf.getByte(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "C": {
                    if (!format.contains("%T#")) {
                        if (bytebuf.capacity() < 1) continue block20;
                        fieldformat = FIELD_FORMAT.matcher(format);
                        if (fieldformat.find()) {
                            length = Integer.parseInt(fieldformat.group(1));
                            length = length > bytebuf.capacity() ? bytebuf.capacity() : length;
                            strField = bytebuf.readCharSequence(length, Charset.forName("utf-8")).toString();
                        }
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "W": {
                    String strReplace;
                    if (bytebuf.capacity() < 2) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedShort(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedShort(0);
                        strField = Integer.toBinaryString((short)value);
                    } else {
                        value = bytebuf.getShort(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "I": {
                    String strReplace;
                    if (bytebuf.capacity() < 4) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getInt(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "X": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "D": {
                    String strReplace;
                    if (bytebuf.capacity() < 8) continue block20;
                    if (format.contains("U")) {
                        value = bytebuf.getUnsignedInt(0);
                        strReplace = format.replace("U", "d");
                        strField = String.format(strReplace, value);
                    } else if (format.contains("D")) {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    } else if (format.contains("B")) {
                        value = bytebuf.getUnsignedInt(0);
                        strField = Long.toBinaryString(value);
                    } else {
                        value = bytebuf.getLong(0);
                        strField = String.format(format, value);
                    }
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                    break;
                }
                case "R": {
                    if (bytebuf.capacity() < 4 || !format.contains("F")) continue block20;
                    strField = String.format(format, value);
                    strOut = strOut.replaceAll(matcher.group(0), strField);
                }
            }
        }
        return strOut;
    }

    public static Long parseS5Time(ReadBuffer io) {
        try {
            short s5time = (short)io.readInt(16, new WithReaderArgs[0]);
            return StaticHelper.s5TimeToDuration(s5time);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeS5Time(WriteBuffer io, PlcValue value) {
        PlcTIME time = (PlcTIME)value;
        Short shortValue = StaticHelper.durationToS5Time(time.getDuration());
        try {
            io.writeUnsignedInt(16, (int)shortValue.shortValue(), new WithWriterArgs[0]);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Integer parseTiaDate(ReadBuffer io) {
        try {
            int daysSinceSiemensEpoch = io.readUnsignedInt(16, new WithReaderArgs[0]);
            return daysSinceSiemensEpoch + daysBetweenUnixAndSiemensEpoch;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeTiaDate(WriteBuffer io, PlcValue value) {
        PlcDATE userDate = (PlcDATE)value;
        int daysSince1990 = userDate.getDaysSinceEpoch() - daysBetweenUnixAndSiemensEpoch;
        try {
            io.writeUnsignedInt(16, daysSince1990, new WithWriterArgs[0]);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String parseS7String(ReadBuffer io, int stringLength, String encoding) {
        try {
            if ("UTF-8".equalsIgnoreCase(encoding)) {
                short maxLength = io.readUnsignedShort(8, new WithReaderArgs[0]);
                short totalStringLength = io.readUnsignedShort(8, new WithReaderArgs[0]);
                byte[] byteArray = new byte[totalStringLength];
                int i = 0;
                while (i < stringLength && io.hasMore(8)) {
                    byte curByte = io.readByte(new WithReaderArgs[0]);
                    if (i >= totalStringLength) {
                        ++i;
                        while (i < stringLength && io.hasMore(8)) {
                            io.readByte(new WithReaderArgs[0]);
                            ++i;
                        }
                        break;
                    }
                    byteArray[i] = curByte;
                    ++i;
                }
                return new String(byteArray, StandardCharsets.UTF_8);
            }
            if ("UTF-16".equalsIgnoreCase(encoding)) {
                int maxLength = io.readUnsignedInt(16, new WithReaderArgs[0]);
                int totalStringLength = io.readUnsignedInt(16, new WithReaderArgs[0]);
                byte[] byteArray = new byte[totalStringLength * 2];
                int i = 0;
                while (i < stringLength && io.hasMore(16)) {
                    short curShort = io.readShort(16, new WithReaderArgs[0]);
                    if (i >= totalStringLength) {
                        ++i;
                        while (i < stringLength && io.hasMore(16)) {
                            io.readShort(16, new WithReaderArgs[0]);
                            ++i;
                        }
                        break;
                    }
                    byteArray[i * 2] = (byte)(curShort >>> 8);
                    byteArray[i * 2 + 1] = (byte)(curShort & 0xFF);
                    ++i;
                }
                return new String(byteArray, StandardCharsets.UTF_16BE);
            }
            throw new PlcRuntimeException("Unsupported string encoding " + encoding);
        }
        catch (ParseException e) {
            throw new PlcRuntimeException("Error parsing string", (Throwable)e);
        }
    }

    public static void serializeS7String(WriteBuffer io, PlcValue value, int stringLength, String encoding) {
        int maxStringLength = 0xFF & Math.min(stringLength, 250);
        int actStringLength = 0xFF & value.getString().length();
        actStringLength = Math.min(maxStringLength, actStringLength);
        switch (encoding) {
            case "UTF-8": {
                byte[] chars = new byte[maxStringLength];
                byte[] actChars = value.getString().substring(0, actStringLength).getBytes(StandardCharsets.UTF_8);
                System.arraycopy(actChars, 0, chars, 0, actChars.length);
                try {
                    io.writeUnsignedInt(8, maxStringLength, new WithWriterArgs[0]);
                    io.writeUnsignedInt(8, actStringLength, new WithWriterArgs[0]);
                    io.writeByteArray(chars, new WithWriterArgs[0]);
                }
                catch (SerializationException ex) {
                    Logger.getLogger(StaticHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            case "UTF-16": {
                byte[] chars = new byte[maxStringLength * 2];
                byte[] actChars = value.getString().substring(0, actStringLength).getBytes(StandardCharsets.UTF_16BE);
                System.arraycopy(actChars, 0, chars, 0, actChars.length);
                try {
                    io.writeUnsignedInt(16, maxStringLength, new WithWriterArgs[0]);
                    io.writeUnsignedInt(16, actStringLength, new WithWriterArgs[0]);
                    io.writeByteArray(chars, new WithWriterArgs[0]);
                }
                catch (SerializationException ex) {
                    Logger.getLogger(StaticHelper.class.getName()).log(Level.SEVERE, null, ex);
                }
                break;
            }
            default: {
                throw new PlcRuntimeException("Unsupported encoding: " + encoding);
            }
        }
    }

    public static short parseSiemensYear(ReadBuffer readBuffer) {
        try {
            short year = readBuffer.readUnsignedShort("year", 8, new WithReaderArgs[]{WithOption.WithEncoding((String)"BCD")});
            if (year < 90) {
                return (short)(2000 + year);
            }
            return (short)(1900 + year);
        }
        catch (ParseException e) {
            throw new RuntimeException("Error parsing year", e);
        }
    }

    public static void serializeSiemensYear(WriteBuffer writeBuffer, PlcValue dateTime) {
        try {
            int year = dateTime.getDateTime().getYear();
            if (year > 2000) {
                writeBuffer.writeUnsignedShort("year", 8, (short)(year - 2000), new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            } else {
                writeBuffer.writeUnsignedShort("year", 8, (short)(year - 1900), new WithWriterArgs[]{WithOption.WithEncoding((String)"BCD")});
            }
        }
        catch (SerializationException e) {
            throw new RuntimeException("Error serializing year", e);
        }
    }

    public static enum CPU_CHARACTERISTICS {
        CH_0x0000(0, "MC7 processing unit (group with index 0000)"),
        CH_0x0001(1, "MC7 processing generating code"),
        CH_0x0002(2, "MC7 interpreter"),
        CH_0x0100(256, "Time system (group with index 0100)"),
        CH_0x0101(257, "1 ms resolution"),
        CH_0x0102(258, "10 ms resolution"),
        CH_0x0103(259, "No real time clock"),
        CH_0x0104(260, "BCD time-of-day format"),
        CH_0x0105(261, "All time-of-day functions"),
        CH_0x0106(262, "SFC 78 \"OB_RT\" is available"),
        CH_0x0200(512, "System response (group with index 0200)"),
        CH_0x0201(513, "Capable of multiprocessor mode"),
        CH_0x0202(514, "Cold restart, warm restart and hot restart possible"),
        CH_0x0203(515, "Cold restart and hot restart possible"),
        CH_0x0204(516, "Warm restart and hot restart possible"),
        CH_0x0205(517, "Only warm restart possible"),
        CH_0x0206(518, "New distributed I/O configuration is possible during\nRUN by using predefined resources"),
        CH_0x0207(519, "H-CPU in stand-alone mode: New distributed I/O configuration\nis possible during RUN by using predefined resources"),
        CH_0x0208(520, "For taking motion control functionality into account"),
        CH_0x0300(768, "MC7 Language description of the CPU (group with index 0300)"),
        CH_0x0301(769, "Reserved"),
        CH_0x0302(770, "All 32 bit fixed-point instructions"),
        CH_0x0303(771, "All floating-point instructions"),
        CH_0x0304(772, "sin, asin, cos, acos, tan, atan, sqr, sqrt, ln, exp"),
        CH_0x0305(773, "Accumulator 3/accumulator 4 with corresponding instructions\n(ENT,PUSH,POP,LEAVE)"),
        CH_0x0306(774, "Master Control Relay instructions"),
        CH_0x0307(775, "Address register 1 exists with corresponding instructions"),
        CH_0x0308(776, "Address register 2 exists with corresponding instructions"),
        CH_0x0309(777, "Operations for area-crossing addressing"),
        CH_0x030A(778, "Operations for area-internal addressing"),
        CH_0x030B(779, "All memory-indirect addressing instructions for bit memory (M)"),
        CH_0x030C(780, "All memory-indirect addressing instructions for data blocks (DB)"),
        CH_0x030D(781, "All memory-indirect addressing instructions for data blocks (DI)"),
        CH_0x030E(782, "All memory-indirect addressing instructions for local data (L)"),
        CH_0x030F(783, "All instructions for parameter transfer in FCs"),
        CH_0x0310(784, "Memory bit edge instructions for process image input (I)"),
        CH_0x0311(785, "Memory bit edge instructions for process image output (Q)"),
        CH_0x0312(786, "Memory bit edge instructions for bit memory (M)"),
        CH_0x0313(787, "Memory bit edge instructions for data blocks (DB)"),
        CH_0x0314(788, "Memory bit edge instructions for data blocks (DI)"),
        CH_0x0315(789, "Memory bit edge instructions for local data (L)"),
        CH_0x0316(790, "Dynamic evaluation of the FC bit"),
        CH_0x0317(791, "Dynamic local data area with the corresponding instructions"),
        CH_0x0318(792, "Reserved"),
        CH_0x0319(793, "Reserved"),
        CH_0x0401(1025, "SFC 87 \"C_DIAG\" is available"),
        CH_0x0402(1026, "SFC 88 \"C_CNTRL\" is available)");

        private final int code;
        private final String description;
        private static final Map<Integer, CPU_CHARACTERISTICS> map;

        static {
            map = new HashMap<Integer, CPU_CHARACTERISTICS>();
            CPU_CHARACTERISTICS[] cPU_CHARACTERISTICSArray = CPU_CHARACTERISTICS.values();
            int n = cPU_CHARACTERISTICSArray.length;
            int n2 = 0;
            while (n2 < n) {
                CPU_CHARACTERISTICS cpuc = cPU_CHARACTERISTICSArray[n2];
                map.put(cpuc.code, cpuc);
                ++n2;
            }
        }

        private CPU_CHARACTERISTICS(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static CPU_CHARACTERISTICS valueOf(String string) {
            return Enum.valueOf(CPU_CHARACTERISTICS.class, string);
        }
    }

    public static enum LED_ID {
        SF(1, "Group error"),
        INTF(2, "Internal error"),
        EXTF(3, "External error"),
        RUN(4, "RUN"),
        STOP(5, "STOP"),
        FRCE(6, "Force"),
        CRST(7, "Cold restart"),
        BAF(8, "Battery fault"),
        USR(9, "User defined"),
        USR1(10, "User defined"),
        BUS1F(11, "Bus error interface 1"),
        BUS2F(12, "Bus error interface 2"),
        REDF(13, "Redundancy error"),
        MSTR(14, "Master"),
        RACK0(15, "Rack number 0"),
        RACK1(16, "Rack number 1"),
        RACK2(17, "Rack number 2"),
        IFM1F(18, "Interface error interface module 1"),
        IFM2F(19, "Interface error interface module 2"),
        BUS3F(20, "Bus error interface 3"),
        MAINT(21, "Maintenance demand"),
        DC24V(22, "DC24V"),
        BUS5F(23, "Bus error interface 5"),
        BUS8F(24, "Bus error interface 8"),
        IF(128, "Init failure"),
        UF(129, "User failure"),
        MF(130, "Monitoring failure"),
        CF(131, "Communication failure"),
        TF(132, "Task failure"),
        APPL_STATE_RED(236, "APPL_STATE_RED"),
        APPL_STATE_GREEN(237, "APPL_STATE_GREEN");

        private final int code;
        private final String description;
        private static final Map<Integer, LED_ID> map;

        static {
            map = new HashMap<Integer, LED_ID>();
            LED_ID[] lED_IDArray = LED_ID.values();
            int n = lED_IDArray.length;
            int n2 = 0;
            while (n2 < n) {
                LED_ID ledid = lED_IDArray[n2];
                map.put(ledid.code, ledid);
                ++n2;
            }
        }

        private LED_ID(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static LED_ID valueOf(String string) {
            return Enum.valueOf(LED_ID.class, string);
        }
    }

    public static enum MODULE {
        CPU(0),
        IM(4),
        FM(128),
        CP(192);

        private final int code;

        private MODULE(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    public static enum OB {
        FREE_CYC(0, "OB1 Free cycle"),
        TOD_INT0(10, "OB10 Time of day interrupt"),
        TOD_INT1(11, "OB11 Time of day interrupt"),
        TOD_INT2(12, "OB12 Time of day interrupt"),
        TOD_INT3(13, "OB13 Time of day interrupt"),
        TOD_INT4(14, "OB14 Time of day interrupt"),
        TOD_INT5(15, "OB15 Time of day interrupt"),
        TOD_INT6(16, "OB16 Time of day interrupt"),
        TOD_INT7(17, "OB17 Time of day interrupt"),
        DEL_INT0(20, "OB20 Time delay interrupt"),
        DEL_INT1(21, "OB21 Time delay interrupt"),
        DEL_INT2(22, "OB22 Time delay interrupt"),
        DEL_INT3(23, "OB23 Time delay interrupt"),
        CYC_INT0(30, "OB30 Cyclic interrupt"),
        CYC_INT1(31, "OB31 Cyclic interrupt"),
        CYC_INT2(32, "OB32 Cyclic interrupt"),
        CYC_INT3(33, "OB33 Cyclic interrupt"),
        CYC_INT4(34, "OB34 Cyclic interrupt"),
        CYC_INT5(35, "OB35 Cyclic interrupt"),
        CYC_INT6(36, "OB36 Cyclic interrupt"),
        CYC_INT7(37, "OB37 Cyclic interrupt"),
        CYC_INT8(38, "OB38 Cyclic interrupt"),
        HW_INT0(40, "OB40 Hardware interrupt"),
        HW_INT1(41, "OB41 Hardware interrupt"),
        HW_INT2(42, "OB42 Hardware interrupt"),
        HW_INT3(43, "OB43 Hardware interrupt"),
        HW_INT4(44, "OB44 Hardware interrupt"),
        HW_INT5(45, "OB45 Hardware interrupt"),
        HW_INT6(46, "OB46 Hardware interrupt"),
        HW_INT7(47, "OB47 Hardware interrupt"),
        BACKGROUND(90, "OB90 Background"),
        COMPLETE_RESTART(100, "OB100 Startup"),
        RESTART(100, "OB101 Background"),
        COLD_RESTART(90, "OB101 Background"),
        CYC_FLT(81, "OB80 Time execution error interrupt"),
        PS_FLT(81, "OB81 Power supply interrupt"),
        IO_FLT1(82, "OB82 Module diagnostic interrupt"),
        IO_FLT2(83, "OB83 Module change interrupt"),
        CPU_FLT(84, "OB84 CPU hardware error interrupt"),
        OBNL_FLT(85, "OB85 Program execution error interrupt"),
        RACK_FLT(86, "OB86 Rack fault interrupt"),
        COMM_FLT(87, "OB87 Communication error interrupt"),
        BREAKUP_ERR(88, "OB88 Process interrupt"),
        SYNC_ERR(121, "OB120 Synchronous error interrupt"),
        PROG_ERR(121, "OB121 Program error interrupt"),
        MOD_ERR(122, "OB122 Module error interrupt");

        private final int code;
        private final String description;
        private static final Map<Integer, OB> map;

        static {
            map = new HashMap<Integer, OB>();
            OB[] oBArray = OB.values();
            int n = oBArray.length;
            int n2 = 0;
            while (n2 < n) {
                OB obid = oBArray[n2];
                map.put(obid.code, obid);
                ++n2;
            }
        }

        private OB(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static OB valueOf(String string) {
            return Enum.valueOf(OB.class, string);
        }
    }

    public static enum SZL {
        ID_0x0000(0, "SZL list."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY00(data);
            }
        }
        ,
        ID_0x0011(17, "Module identification."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY11(data);
            }
        }
        ,
        ID_0x0012(18, "CPU characteristics ."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY12(data);
            }
        }
        ,
        ID_0x0013(19, "User memory areas."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY13(data);
            }
        }
        ,
        ID_0x0014(20, "System areas."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY14(data);
            }
        }
        ,
        ID_0x0015(21, "Block types."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY15(data);
            }
        }
        ,
        ID_0x001C(28, "Component identification."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY1C(data);
            }
        }
        ,
        ID_0x0022(34, "Interrupt status."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY22(data);
            }
        }
        ,
        ID_0x0025(37, "Assignment between process image partitions and OBs."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY25(data);
            }
        }
        ,
        ID_0x0032(50, "Communication status data."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY32(data);
            }
        }
        ,
        ID_0x0071(113, "H CPU group information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY71(data);
            }
        }
        ,
        ID_0x0074(116, "Status of the module LEDs."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY74(data);
            }
        }
        ,
        ID_0x0075(117, "Switched DP slaves in the H-system."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY75(data);
            }
        }
        ,
        ID_0x0090(144, "DP Master System Information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY90(data);
            }
        }
        ,
        ID_0x0091(145, "Module status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY91(data);
            }
        }
        ,
        ID_0x0092(146, "Rack / station status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY92(data);
            }
        }
        ,
        ID_0x0094(148, "Rack / station status information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY94(data);
            }
        }
        ,
        ID_0x0095(149, "Extended DP master system / PROFINET IO system information."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY95(data);
            }
        }
        ,
        ID_0x0096(150, "Module status information, PROFINET IO and PROFIBUS DP."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY96(data);
            }
        }
        ,
        ID_0x009C(156, "Tool changer information (PROFINET IO)."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXY9C(data);
            }
        }
        ,
        ID_0x00A0(160, "Diagnostic buffer of the CPU."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXYA0(data);
            }
        }
        ,
        ID_0x00B1(177, "Module diagnostic information (data record 0) ."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXYB1(data);
            }
        }
        ,
        ID_0x00B2(178, "Module diagnostic information (data record 1),geographical address."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXYB2(data);
            }
        }
        ,
        ID_0x00B3(179, "Module diagnostic information (data record 1),logical address."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXYB3(data);
            }
        }
        ,
        ID_0x00B4(180, "Diagnostic data of a DP slave."){

            @Override
            public StringBuilder execute(ByteBuf data) {
                return SZL.ID_0xXYB4(data);
            }
        };

        private final int code;
        private final String description;
        private static final Map<Integer, SZL> map;

        static {
            map = new HashMap<Integer, SZL>();
            SZL[] sZLArray = SZL.values();
            int n = sZLArray.length;
            int n2 = 0;
            while (n2 < n) {
                SZL subszl = sZLArray[n2];
                map.put(subszl.code, subszl);
                ++n2;
            }
        }

        private SZL(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract StringBuilder execute(ByteBuf var1);

        private static StringBuilder ID_0xXY00(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("SZL", (int)data.readShort());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb.append(jsonszl.toString());
        }

        private static StringBuilder ID_0xXY11(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("INDEX", (int)data.readShort());
                    byte[] bytestr = new byte[20];
                    data.readBytes(bytestr, 0, 20);
                    jo.put("MIFB", (Object)new String(bytestr));
                    jo.put("BGTYP", (int)data.readShort());
                    jo.put("AUSBG1", (int)data.readShort());
                    jo.put("AUSBG2", (int)data.readShort());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb.append(jsonszl.toString());
        }

        private static StringBuilder ID_0xXY12(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short code = 0;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            short szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", (int)szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr - 1) {
                    code = data.readShort();
                    JSONObject jo = new JSONObject();
                    jo.put(CPU_CHARACTERISTICS.valueOf(code).name(), (Object)CPU_CHARACTERISTICS.valueOf(code).getDescription());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            return sb.append(jsonszl.toString());
        }

        private static StringBuilder ID_0xXY13(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            boolean code = false;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("INDEX", (int)data.readShort());
                    jo.put("CODE", (int)data.readShort());
                    jo.put("SIZE", data.readInt());
                    jo.put("MODE", (int)data.readShort());
                    jo.put("GRANU", (int)data.readShort());
                    jo.put("BER1", data.readInt());
                    jo.put("BELEGT1", data.readInt());
                    jo.put("BLOCK1", data.readInt());
                    jo.put("BER2", data.readInt());
                    jo.put("BELEGT2", data.readInt());
                    jo.put("BLOCK2", data.readInt());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY14(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            boolean index = false;
            boolean code = false;
            boolean quantity = false;
            boolean reman = false;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("INDEX", (int)data.readShort());
                    jo.put("CODE", (int)data.readShort());
                    jo.put("QUANTITY", (int)data.readShort());
                    jo.put("REMAN", (int)data.readShort());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY15(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("INDEX", (int)data.readShort());
                    jo.put("MAXANZ", (int)data.readShort());
                    jo.put("MAXLNG", (int)data.readShort());
                    jo.put("MAXABL", data.readInt());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY1C(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short index = 0;
            byte index_b0 = 0;
            byte index_b1 = 0;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    index = data.getShort(data.readerIndex());
                    index_b0 = data.readByte();
                    index_b1 = data.readByte();
                    jo.put("INDEX", (int)data.readShort());
                    switch (index_b1) {
                        case 1: 
                        case 2: {
                            byte[] strbyte = new byte[24];
                            data.readBytes(strbyte, 0, 24);
                            jo.put("NAME", (Object)new String(strbyte));
                            jo.put("RESERVED", data.readInt());
                            break;
                        }
                        case 3: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            jo.put("TAG", (Object)new String(strbyte));
                            break;
                        }
                        case 4: {
                            byte[] strbyte = new byte[26];
                            data.readBytes(strbyte, 0, 26);
                            jo.put("COPYRIGHT", (Object)new String(strbyte));
                            ByteBuf data2 = data.readSlice(6);
                            jo.put("RESERVED", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                            break;
                        }
                        case 5: {
                            byte[] strbyte = new byte[24];
                            data.readBytes(strbyte, 0, 24);
                            jo.put("SERIALN", (Object)new String(strbyte));
                            ByteBuf data2 = data.readSlice(8);
                            jo.put("RESERVED", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            jo.put("CPU_TYPE", (Object)new String(strbyte));
                            break;
                        }
                        case 8: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            jo.put("SN_MMC", (Object)new String(strbyte));
                            break;
                        }
                        case 9: {
                            jo.put("MANUFACTURER_ID", (int)data.readShort());
                            jo.put("PROFILE_ID", (int)data.readShort());
                            jo.put("PROFILE_SPECIFIC_TYPE", (int)data.readShort());
                            ByteBuf data2 = data.readSlice(26);
                            jo.put("RESERVED", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                            break;
                        }
                        case 10: {
                            byte[] strbyte = new byte[26];
                            data.readBytes(strbyte, 0, 26);
                            jo.put("OEM_COPYRIGHT", (Object)new String(strbyte));
                            jo.put("OEM_ID", (int)data.readShort());
                            jo.put("OEM_ADD_ID", data.readInt());
                            break;
                        }
                        case 11: {
                            byte[] strbyte = new byte[32];
                            data.readBytes(strbyte, 0, 32);
                            jo.put("LOC_ID", (Object)new String(strbyte));
                            break;
                        }
                        case 12: {
                            byte[] strbyte = new byte[10];
                            data.readBytes(strbyte, 0, 10);
                            jo.put("ORDER_NUMBER_1", (Object)new String(strbyte));
                            data.readShort();
                            byte[] strbyte2 = new byte[2];
                            data.readBytes(strbyte2, 0, 2);
                            jo.put("PRODUCT_VERSION", (Object)new String(strbyte2));
                            data.readByte();
                            ByteBuf data2 = data.readSlice(17);
                            jo.put("SERIAL", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                            break;
                        }
                        case 13: {
                            byte[] strbyte = new byte[10];
                            data.readBytes(strbyte, 0, 10);
                            jo.put("ORDER_NUMBER_2", (Object)new String(strbyte));
                            data.readShort();
                            byte[] strbyte2 = new byte[2];
                            data.readBytes(strbyte2, 0, 2);
                            jo.put("PRODUCT_VERSION", (Object)new String(strbyte2));
                            data.readByte();
                            ByteBuf data2 = data.readSlice(17);
                            jo.put("SERIAL", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                            break;
                        }
                        case 14: {
                            byte[] strbyte = new byte[18];
                            data.readBytes(strbyte, 0, 18);
                            jo.put("SERIAL_NUMBER", (Object)new String(strbyte));
                            ByteBuf data2 = data.readSlice(14);
                            jo.put("RESERVED", (Object)ByteBufUtil.hexDump((ByteBuf)data2));
                        }
                    }
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY22(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    ByteBuf infobytes = data.readSlice(20);
                    jo.put("INFO", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    jo.put("AL_1", (int)data.readShort());
                    jo.put("AL_2", (int)data.readShort());
                    jo.put("AL_3", data.readInt());
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY25(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("TPA_NR", Short.toUnsignedInt(data.readByte()));
                    jo.put("TPA_USE", Short.toUnsignedInt(data.readByte()));
                    jo.put("OB_NR", Short.toUnsignedInt(data.readByte()));
                    jo.put("RESERVED", Short.toUnsignedInt(data.readByte()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY32(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            ByteBuf infobytes = null;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    infobytes = data.readSlice(40);
                    jo.put("DATA", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY71(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            Object infobytes = null;
            short szl_id = data.readShort();
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = data.readShort();
            try {
                jsonszl.put("SZL-ID", (int)szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    JSONObject jo = new JSONObject();
                    jo.put("REDINF", Short.toUnsignedInt(data.readShort()));
                    jo.put("MWSTAT1", Short.toUnsignedInt(data.readByte()));
                    jo.put("MWSTAT2", Short.toUnsignedInt(data.readByte()));
                    jo.put("HSFCINFO", Short.toUnsignedInt(data.readShort()));
                    jo.put("SAMFEHL", Short.toUnsignedInt(data.readShort()));
                    jo.put("BZ_CPU_0", Short.toUnsignedInt(data.readShort()));
                    jo.put("BZ_CPU_1", Short.toUnsignedInt(data.readShort()));
                    jo.put("BZ_CPU_2", Short.toUnsignedInt(data.readShort()));
                    jo.put("CPU_VALID", Short.toUnsignedInt(data.readByte()));
                    jo.put("HSYNC_F", Short.toUnsignedInt(data.readByte()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY74(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("CPU_LED_ID", Short.toUnsignedInt(data.readShort()));
                    jo.put("LED_ON", Short.toUnsignedInt(data.readByte()));
                    jo.put("LED_BLINK", Short.toUnsignedInt(data.readByte()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY75(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("ADR1_BGT0", Short.toUnsignedInt(data.readShort()));
                    jo.put("ADR2_BGT0", Short.toUnsignedInt(data.readShort()));
                    jo.put("ADR1_BGT1", Short.toUnsignedInt(data.readShort()));
                    jo.put("ADR2_BGT1", Short.toUnsignedInt(data.readShort()));
                    jo.put("RESERVED", data.readInt());
                    jo.put("LOGADR", Short.toUnsignedInt(data.readShort()));
                    jo.put("SLAVESTATUS", Short.toUnsignedInt(data.readShort()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY90(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("DP_M_ID", Short.toUnsignedInt(data.readByte()));
                    jo.put("RACK_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("STECKPL_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("SUBM_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("LOGADR", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_SYS_CPU", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_SYS_DPM", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_STATE", Short.toUnsignedInt(data.readByte()));
                    infobytes = data.readSlice(3);
                    jo.put("RESERVED", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY91(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            Object infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("ADR1", Short.toUnsignedInt(data.readShort()));
                    jo.put("ADR2", Short.toUnsignedInt(data.readShort()));
                    jo.put("LOGADR", Short.toUnsignedInt(data.readShort()));
                    jo.put("SOLLTYP", Short.toUnsignedInt(data.readShort()));
                    jo.put("ISTTYP", Short.toUnsignedInt(data.readShort()));
                    jo.put("RESERVIERT", Short.toUnsignedInt(data.readShort()));
                    jo.put("EASTAT", Short.toUnsignedInt(data.readShort()));
                    jo.put("BER_BGBR", Short.toUnsignedInt(data.readShort()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY92(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            Object infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("STATUS_00", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_01", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_02", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_03", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_04", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_05", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_06", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_07", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_08", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_09", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_10", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_11", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_12", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_13", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_14", Short.toUnsignedInt(data.readByte()));
                    jo.put("STATUS_15", Short.toUnsignedInt(data.readByte()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY94(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("INDEX", Short.toUnsignedInt(data.readShort()));
                    infobytes = data.readSlice(256);
                    jo.put("STATUS", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY95(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("DP_M_ID", Short.toUnsignedInt(data.readByte()));
                    jo.put("RACK_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("STECKPL_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("SUBM_DP_M", Short.toUnsignedInt(data.readByte()));
                    jo.put("LOGADR", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_SYS_CPU", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_SYS_DPM", Short.toUnsignedInt(data.readShort()));
                    jo.put("DP_M_STATE", Short.toUnsignedInt(data.readByte()));
                    jo.put("DP_ADDRESS", Short.toUnsignedInt(data.readByte()));
                    jo.put("RESERVED01", Short.toUnsignedInt(data.readShort()));
                    jo.put("TSAL_OB", Short.toUnsignedInt(data.readByte()));
                    jo.put("BAUDRATE", data.readLong());
                    jo.put("RESERVED02", Short.toUnsignedInt(data.readByte()));
                    jo.put("DP_ISO_TAKT", data.readLong());
                    infobytes = data.readSlice(16);
                    jo.put("RESERVED03", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY96(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("LOGADR", Short.toUnsignedInt(data.readShort()));
                    jo.put("SYSTEM", Short.toUnsignedInt(data.readShort()));
                    jo.put("API", data.readInt());
                    jo.put("STATION", Short.toUnsignedInt(data.readShort()));
                    jo.put("SLOT", Short.toUnsignedInt(data.readShort()));
                    jo.put("SUBSLOT", Short.toUnsignedInt(data.readShort()));
                    jo.put("OFFSET", Short.toUnsignedInt(data.readShort()));
                    infobytes = data.readSlice(14);
                    jo.put("SOLLTYP", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    jo.put("SOLL_UNGLEIC_LST_TYP", Short.toUnsignedInt(data.readShort()));
                    jo.put("RESERVED01", Short.toUnsignedInt(data.readShort()));
                    jo.put("EASTAT", Short.toUnsignedInt(data.readShort()));
                    jo.put("BER_BGBR", Short.toUnsignedInt(data.readShort()));
                    infobytes = data.readSlice(10);
                    jo.put("RESERVED02", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXY9C(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            Object infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("STATIONW", Short.toUnsignedInt(data.readShort()));
                    jo.put("LOGADRW", Short.toUnsignedInt(data.readShort()));
                    jo.put("STATIONWZK", Short.toUnsignedInt(data.readShort()));
                    jo.put("STATIONWZW", Short.toUnsignedInt(data.readShort()));
                    jo.put("SLOTWZW", Short.toUnsignedInt(data.readShort()));
                    jo.put("SUBSLOTWZW", Short.toUnsignedInt(data.readShort()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXYA0(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            short id = 0;
            ByteBuf infobytes = null;
            int n_dr = 0;
            int szl_id = Short.toUnsignedInt(data.readShort());
            short szl_index = data.readShort();
            short szl_lengthdr = data.readShort();
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", (int)szl_index);
                jsonszl.put("LENGTHDR", (int)szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                switch (szl_id) {
                    case 160: {
                        while (data.isReadable()) {
                            jo = new JSONObject();
                            id = data.readShort();
                            jo.put("EVENT_ID", (int)id);
                            infobytes = data.readSlice(10);
                            jo.put("INFO", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                            infobytes = data.readSlice(8);
                            jo.put("TIMESTAMP", (Object)SZL.readDateAndTime(infobytes).toString());
                            jo.put("DESCRIPTION", (Object)S7DiagnosticEventId.valueOf(id).getDescription());
                            ja.put((Object)jo);
                            ++n_dr;
                        }
                        jsonszl.put("N_DR", n_dr);
                        break;
                    }
                    case 416: {
                        int i = 0;
                        while (i < szl_n_dr) {
                            jo = new JSONObject();
                            id = data.readShort();
                            jo.put("EVENT_ID", (int)id);
                            infobytes = data.readSlice(10);
                            jo.put("INFO", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                            infobytes = data.readSlice(8);
                            jo.put("TIMESTAMP", (Object)SZL.readDateAndTime(infobytes).toString());
                            jo.put("DESCRIPTION", (Object)S7DiagnosticEventId.valueOf(id).getDescription());
                            ja.put((Object)jo);
                            ++i;
                        }
                        break;
                    }
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXYB1(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            Object infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                int i = 1;
                while (i <= szl_n_dr) {
                    jo = new JSONObject();
                    jo.put("BYTE0", Short.toUnsignedInt(data.readByte()));
                    jo.put("BYTE1", Short.toUnsignedInt(data.readByte()));
                    jo.put("BYTE2", Short.toUnsignedInt(data.readByte()));
                    jo.put("BYTE3", Short.toUnsignedInt(data.readByte()));
                    ja.put((Object)jo);
                    ++i;
                }
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXYB2(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                jo = new JSONObject();
                infobytes = data.readSlice(szl_lengthdr);
                jo.put("DATA", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                ja.put((Object)jo);
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXYB3(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                jo = new JSONObject();
                infobytes = data.readSlice(szl_lengthdr);
                jo.put("DATA", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                ja.put((Object)jo);
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static StringBuilder ID_0xXYB4(ByteBuf data) {
            StringBuilder sb = new StringBuilder();
            JSONObject jsonszl = new JSONObject();
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            ByteBuf infobytes = null;
            int szl_id = Short.toUnsignedInt(data.readShort());
            int szl_index = Short.toUnsignedInt(data.readShort());
            int szl_lengthdr = Short.toUnsignedInt(data.readShort());
            int szl_n_dr = Short.toUnsignedInt(data.readShort());
            try {
                jsonszl.put("SZL-ID", szl_id);
                jsonszl.put("INDEX", szl_index);
                jsonszl.put("LENGTHDR", szl_lengthdr);
                jsonszl.put("N_DR", szl_n_dr);
                jo = new JSONObject();
                jo.put("STATUS1", Short.toUnsignedInt(data.readByte()));
                jo.put("STATUS2", Short.toUnsignedInt(data.readByte()));
                jo.put("STATUS3", Short.toUnsignedInt(data.readByte()));
                jo.put("STAT_NR", Short.toUnsignedInt(data.readByte()));
                jo.put("KEN_HI", Short.toUnsignedInt(data.readByte()));
                jo.put("KEN_LO", Short.toUnsignedInt(data.readByte()));
                infobytes = data.readSlice(szl_lengthdr - 6);
                jo.put("DATA", (Object)ByteBufUtil.hexDump((ByteBuf)infobytes));
                ja.put((Object)jo);
                jsonszl.put("RECORDS", (Object)ja);
            }
            catch (Exception ex) {
                sb.append(ex);
            }
            sb.append(jsonszl.toString());
            return sb;
        }

        private static LocalDateTime readDateAndTime(ByteBuf data) {
            int year = SZL.convertByteToBcd(data.readByte());
            byte themonth = data.readByte();
            int month = SZL.convertByteToBcd(themonth == 0 ? (byte)1 : themonth);
            byte theday = data.readByte();
            int day = SZL.convertByteToBcd(theday == 0 ? (byte)1 : theday);
            int hour = SZL.convertByteToBcd(data.readByte());
            int minute = SZL.convertByteToBcd(data.readByte());
            int second = SZL.convertByteToBcd(data.readByte());
            int milliseconds = (data.readShort() & 0xFFF0) >> 4;
            int cen = ((milliseconds & 0xF00) >> 8) * 100;
            int dec = ((milliseconds & 0xF0) >> 4) * 10;
            milliseconds = cen + dec + (milliseconds & 0xF);
            int nanoseconds = milliseconds * 1000000;
            year = year >= 90 ? (year += 1900) : (year += 2000);
            return LocalDateTime.of(year, month, day, hour, minute, second, nanoseconds);
        }

        private static int convertByteToBcd(byte incomingByte) {
            int dec = (incomingByte >> 4) * 10;
            return dec + (incomingByte & 0xF);
        }

        private static short convertShortToBcd(short incomingShort) {
            return (short)((incomingShort >> 8) * 100 + (incomingShort >> 4) * 10 + (incomingShort & 0xF));
        }

        public static SZL valueOf(String string) {
            return Enum.valueOf(SZL.class, string);
        }
    }
}

