/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.jpa.repository.cdi.BeanManagerQueryRewriterProvider;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

class JpaRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<EntityManager> entityManagerBean;
    private final QueryRewriterProvider queryRewriterProvider;

    JpaRepositoryBean(BeanManager beanManager, Bean<EntityManager> entityManagerBean, Set<Annotation> qualifiers, Class<T> repositoryType, Optional<CustomRepositoryImplementationDetector> detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        Assert.notNull(entityManagerBean, (String)"EntityManager bean must not be null");
        this.entityManagerBean = entityManagerBean;
        this.queryRewriterProvider = new BeanManagerQueryRewriterProvider(beanManager);
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        EntityManager entityManager = (EntityManager)this.getDependencyInstance(this.entityManagerBean, EntityManager.class);
        Supplier<RepositoryFactorySupport> repositoryFactorySupportSupplier = () -> {
            JpaRepositoryFactory jpaRepositoryFactory = new JpaRepositoryFactory(entityManager);
            jpaRepositoryFactory.setQueryRewriterProvider(this.queryRewriterProvider);
            return jpaRepositoryFactory;
        };
        return (T)this.create(repositoryFactorySupportSupplier, repositoryType);
    }
}

