/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Parameter;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.StringUtil;
import java.sql.ParameterMetaData;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbParameterMetaData
extends Filterable
implements ParameterMetaData {
    public DmdbConnection connection;
    private Parameter[] params;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbParameterMetaData(DmdbConnection dmdbConnection, Parameter[] parameterArray) {
        super(dmdbConnection, null);
        this.connection = dmdbConnection;
        this.params = parameterArray;
    }

    private Parameter checkIndex(int n2) {
        if (n2 < 1 || n2 > this.params.length) {
            DBError.ECJDBC_INVALID_SEQUENCE_NUMBER.throwz(new Object[0]);
        }
        return this.params[n2 - 1];
    }

    public int do_getParameterCount() {
        return this.params.length;
    }

    public int do_isNullable(int n2) {
        Parameter parameter = this.checkIndex(n2);
        return parameter.nullable ? 1 : 0;
    }

    public boolean do_isSigned(int n2) {
        Parameter parameter = this.checkIndex(n2);
        return DmdbType.isNumeric(parameter.type);
    }

    public int do_getPrecision(int n2) {
        Parameter parameter = this.checkIndex(n2);
        return DmdbType.d2jPrec(parameter);
    }

    public int do_getScale(int n2) {
        Parameter parameter = this.checkIndex(n2);
        return parameter.scale;
    }

    public int do_getParameterType(int n2) {
        Parameter parameter = this.checkIndex(n2);
        return DmdbType.d2jType(parameter, this.connection);
    }

    public String do_getParameterTypeName(int n2) {
        Parameter parameter = this.checkIndex(n2);
        if (DmdbType.isComplexType(parameter.type, parameter.scale)) {
            return parameter.typeDescriptor.getFulName();
        }
        String string = parameter.typeName;
        if (StringUtil.isEmpty(string)) {
            string = DmdbType.getDTypeName(parameter);
        }
        return string;
    }

    public String do_getParameterClassName(int n2) {
        int n3 = this.do_getParameterType(n2);
        return DmdbType.getClassName(n3, this.params[n2 - 1].type);
    }

    public int do_getParameterMode(int n2) {
        Parameter parameter = this.checkIndex(n2);
        int n3 = 0;
        switch (parameter.ioType) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: {
                n3 = 4;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        return n3;
    }

    @Override
    public int getParameterCount() {
        if (this.filterChain == null) {
            return this.do_getParameterCount();
        }
        return this.filterChain.reset().ParameterMetaData_getParameterCount(this);
    }

    @Override
    public int isNullable(int n2) {
        if (this.filterChain == null) {
            return this.do_isNullable(n2);
        }
        return this.filterChain.reset().ParameterMetaData_isNullable(this, n2);
    }

    @Override
    public boolean isSigned(int n2) {
        if (this.filterChain == null) {
            return this.do_isSigned(n2);
        }
        return this.filterChain.reset().ParameterMetaData_isSigned(this, n2);
    }

    @Override
    public int getPrecision(int n2) {
        if (this.filterChain == null) {
            return this.do_getPrecision(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getPrecision(this, n2);
    }

    @Override
    public int getScale(int n2) {
        if (this.filterChain == null) {
            return this.do_getScale(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getScale(this, n2);
    }

    @Override
    public int getParameterType(int n2) {
        if (this.filterChain == null) {
            return this.do_getParameterType(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getParameterType(this, n2);
    }

    @Override
    public String getParameterTypeName(int n2) {
        if (this.filterChain == null) {
            return this.do_getParameterTypeName(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getParameterTypeName(this, n2);
    }

    @Override
    public String getParameterClassName(int n2) {
        if (this.filterChain == null) {
            return this.do_getParameterClassName(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getParameterClassName(this, n2);
    }

    @Override
    public int getParameterMode(int n2) {
        if (this.filterChain == null) {
            return this.do_getParameterMode(n2);
        }
        return this.filterChain.reset().ParameterMetaData_getParameterMode(this, n2);
    }

    public Object unwrap(Class clazz) {
        return clazz.cast(this);
    }

    public boolean isWrapperFor(Class clazz) {
        return clazz.isInstance(this);
    }

    public String getParameterName(int n2) {
        this.checkIndex(n2);
        return this.params[n2 - 1].name;
    }
}

