/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    public static final int BINARY = 1;
    public static final int ASCII = 2;
    private int type = 1;
    public static final int IS_BLOB = 1;
    public static final int IS_CLOB = 2;
    private int typeFlag;
    private Object obj;
    private long objPos;
    private byte[] buf;
    private int bufPos;

    public DmdbOutputStream(Object object, long l2) {
        this.obj = object;
        this.objPos = l2;
        this.buf = new byte[32640];
        this.bufPos = 0;
        if (object instanceof DmdbBlob) {
            this.typeFlag = 1;
        } else if (object instanceof DmdbClob) {
            this.typeFlag = 2;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
    }

    public DmdbOutputStream(Object object, long l2, int n2) {
        this(object, l2);
        this.type = n2;
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0) {
            DBError.throwIOException("off IndexOutOfBounds :" + n2);
        }
        if (n3 < 0) {
            DBError.throwIOException("len IndexOutOfBounds :" + n3);
        }
        if (n2 + n3 > byArray.length) {
            DBError.throwIOException("off + len IndexOutOfBounds :" + n2 + n3);
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.bufLeaveLen();
            if (n5 == 0) {
                this.flush();
                n5 = this.bufLeaveLen();
            }
            int n6 = Math.min(n5, n3 - n4);
            System.arraycopy(byArray, n2, this.buf, this.bufPos, n6);
            n4 += n6;
            this.bufPos += n6;
            n2 += n6;
        }
    }

    @Override
    public void write(byte[] byArray) {
        super.write(byArray);
    }

    @Override
    public void flush() {
        if (this.bufPos <= 0) {
            return;
        }
        try {
            switch (this.typeFlag) {
                case 1: {
                    this.writeToBlob();
                    break;
                }
                case 2: {
                    this.writeToClob();
                    break;
                }
                default: {
                    DBError.throwIOException("Fatal error occured in DmdbOutputStream ");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
    }

    @Override
    public void close() {
        this.flush();
        super.close();
    }

    private int bufLeaveLen() {
        return this.buf == null ? 0 : this.buf.length - this.bufPos;
    }

    private void writeToBlob() {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbBlob dmdbBlob = (DmdbBlob)this.obj;
        int n2 = dmdbBlob.do_setBytes(this.objPos, this.buf, 0, this.bufPos);
        this.objPos += (long)n2;
        this.bufPos = 0;
    }

    private void writeToClob() {
        if (this.bufPos <= 0) {
            return;
        }
        DmdbClob dmdbClob = (DmdbClob)this.obj;
        String string = "";
        string = this.type == 2 ? String.valueOf(ConvertUtil.ASCIIBytesToJavaChars(this.buf, 0, this.bufPos)) : ByteUtil.getString(this.buf, 0, this.bufPos, dmdbClob.serverEncoding);
        int n2 = dmdbClob.do_setString(this.objPos, string);
        this.objPos += (long)n2;
        this.bufPos = 0;
    }
}

