/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteConvertUtils;

public enum IpmiPayloadType implements IpmiCode.Code
{
    IPMI(0, 1, 0),
    SOL(1, 1, 0),
    OEM_EXPLICIT(2, -1, -1),
    RMCPOpenSessionRequest(16, 1, 0),
    RMCPOpenSessionResponse(17, 1, 0),
    RAKPMessage1(18, 1, 0),
    RAKPMessage2(19, 1, 0),
    RAKPMessage3(20, 1, 0),
    RAKPMessage4(21, 1, 0),
    OEM0(32, -1, -1),
    OEM1(33, -1, -1),
    OEM2(34, -1, -1),
    OEM3(35, -1, -1),
    OEM4(36, -1, -1),
    OEM5(37, -1, -1),
    OEM6(38, -1, -1),
    OEM7(39, -1, -1);

    private final byte code;
    private final int majorFormat;
    private final int minorFormat;
    public static final byte MASK = 63;

    private IpmiPayloadType(int code, int majorFormat, int minorFormat) {
        this.code = ByteConvertUtils.checkCastByte(code);
        this.majorFormat = majorFormat;
        this.minorFormat = minorFormat;
    }

    @Override
    public byte getCode() {
        return this.code;
    }
}

