/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.azure.resource;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.contrib.azure.resource.AzureMetadataService;
import io.opentelemetry.contrib.azure.resource.CloudResourceProvider;
import io.opentelemetry.contrib.azure.resource.IncubatingAttributes;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class AzureVmResourceProvider
extends CloudResourceProvider {
    private static final Map<String, Entry> COMPUTE_MAPPING = new HashMap<String, Entry>();
    private static final Logger logger;
    private final Supplier<Optional<String>> client;

    public AzureVmResourceProvider() {
        this(AzureMetadataService.defaultClient());
    }

    AzureVmResourceProvider(Supplier<Optional<String>> client) {
        this.client = client;
    }

    public int order() {
        return 100;
    }

    public Resource createResource(ConfigProperties config) {
        return this.client.get().map(body -> AzureVmResourceProvider.parseMetadata(body, COMPUTE_MAPPING, "azure_vm")).orElse(Resource.empty());
    }

    static Resource parseMetadata(String body, Map<String, Entry> computeMapping, String platform) {
        AttributesBuilder builder = AzureVmResourceProvider.azureAttributeBuilder(platform);
        try (JsonParser parser = AzureMetadataService.JSON_FACTORY.createParser(body);){
            parser.nextToken();
            AzureVmResourceProvider.parseResponse(parser, builder, computeMapping);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Can't get Azure VM metadata", e);
        }
        return Resource.create((Attributes)builder.build());
    }

    @NotNull
    static AttributesBuilder azureAttributeBuilder(String platform) {
        AttributesBuilder builder = Attributes.builder();
        builder.put(IncubatingAttributes.CLOUD_PROVIDER, (Object)"azure");
        builder.put(IncubatingAttributes.CLOUD_PLATFORM, (Object)platform);
        return builder;
    }

    static void parseResponse(JsonParser parser, AttributesBuilder builder, Map<String, Entry> computeMapping) throws IOException {
        if (!parser.isExpectedStartObjectToken()) {
            logger.log(Level.FINE, "Couldn't parse ECS metadata, invalid JSON");
            return;
        }
        AzureVmResourceProvider.consumeJson(parser, (name, value) -> {
            try {
                if (name.equals("compute")) {
                    AzureVmResourceProvider.consumeCompute(parser, builder, computeMapping);
                } else {
                    parser.skipChildren();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private static void consumeCompute(JsonParser parser, AttributesBuilder builder, Map<String, Entry> computeMapping) throws IOException {
        AzureVmResourceProvider.consumeJson(parser, (computeName, computeValue) -> {
            Entry entry = (Entry)computeMapping.get(computeName);
            if (entry != null) {
                builder.put(entry.key, (Object)entry.transform.apply((String)computeValue));
            } else {
                try {
                    parser.skipChildren();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static void consumeJson(JsonParser parser, BiConsumer<String, String> consumer) throws IOException {
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            consumer.accept(parser.currentName(), parser.nextTextValue());
        }
    }

    static {
        COMPUTE_MAPPING.put("location", new Entry(IncubatingAttributes.CLOUD_REGION));
        COMPUTE_MAPPING.put("resourceId", new Entry(IncubatingAttributes.CLOUD_RESOURCE_ID));
        COMPUTE_MAPPING.put("vmId", new Entry(IncubatingAttributes.HOST_ID));
        COMPUTE_MAPPING.put("name", new Entry(IncubatingAttributes.HOST_NAME));
        COMPUTE_MAPPING.put("vmSize", new Entry(IncubatingAttributes.HOST_TYPE));
        COMPUTE_MAPPING.put("osType", new Entry(IncubatingAttributes.OS_TYPE));
        COMPUTE_MAPPING.put("version", new Entry(IncubatingAttributes.OS_VERSION));
        COMPUTE_MAPPING.put("vmScaleSetName", new Entry((AttributeKey<String>)AttributeKey.stringKey((String)"azure.vm.scaleset.name")));
        COMPUTE_MAPPING.put("sku", new Entry((AttributeKey<String>)AttributeKey.stringKey((String)"azure.vm.sku")));
        logger = Logger.getLogger(AzureVmResourceProvider.class.getName());
    }

    static class Entry {
        final AttributeKey<String> key;
        final Function<String, String> transform;

        Entry(AttributeKey<String> key) {
            this(key, Function.identity());
        }

        Entry(AttributeKey<String> key, Function<String, String> transform) {
            this.key = key;
            this.transform = transform;
        }
    }
}

