/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQuery;
import org.apache.hertzbeat.common.entity.dto.query.DatasourceQueryData;
import org.apache.hertzbeat.warehouse.db.QueryExecutor;
import org.apache.hertzbeat.warehouse.service.DatasourceQueryService;
import org.springframework.stereotype.Service;

@Service
public class DatasourceQueryServiceImpl
implements DatasourceQueryService {
    Map<String, QueryExecutor> executorMap;

    DatasourceQueryServiceImpl(List<QueryExecutor> executors) {
        this.executorMap = executors.stream().collect(Collectors.toMap(QueryExecutor::getDatasource, executor -> executor));
    }

    @Override
    public List<DatasourceQueryData> query(List<DatasourceQuery> queries) {
        if (queries == null) {
            throw new IllegalArgumentException("No query found");
        }
        ArrayList<DatasourceQueryData> datasourceQueryDataList = new ArrayList<DatasourceQueryData>();
        for (DatasourceQuery datasourceQuery : queries) {
            QueryExecutor executor = this.executorMap.get(datasourceQuery.getDatasource());
            if (executor == null) {
                throw new IllegalArgumentException("Unsupported datasource: " + datasourceQuery.getDatasource());
            }
            datasourceQueryDataList.add(executor.query(datasourceQuery));
        }
        return datasourceQueryDataList;
    }
}

