/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.keygen;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ArrayUtil;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class Jdbc3KeyGenerator
implements KeyGenerator {
    private static final String SECOND_GENERIC_PARAM_NAME = "param2";
    public static final Jdbc3KeyGenerator INSTANCE = new Jdbc3KeyGenerator();
    private static final String MSG_TOO_MANY_KEYS = "Too many keys are generated. There are only %d target objects. You either specified a wrong 'keyProperty' or encountered a driver bug like #1523.";

    @Override
    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    @Override
    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        this.processBatch(ms, stmt, parameter);
    }

    public void processBatch(MappedStatement ms, Statement stmt, Object parameter) {
        String[] keyProperties = ms.getKeyProperties();
        if (keyProperties == null || keyProperties.length == 0) {
            return;
        }
        try (ResultSet rs = stmt.getGeneratedKeys();){
            ResultSetMetaData rsmd = rs.getMetaData();
            Configuration configuration = ms.getConfiguration();
            if (rsmd.getColumnCount() < keyProperties.length) {
            } else {
                this.assignKeys(configuration, rs, rsmd, keyProperties, parameter);
            }
        }
        catch (Exception e) {
            throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, e);
        }
    }

    private void assignKeys(Configuration configuration, ResultSet rs, ResultSetMetaData rsmd, String[] keyProperties, Object parameter) throws SQLException {
        if (parameter instanceof MapperMethod.ParamMap || parameter instanceof DefaultSqlSession.StrictMap) {
            this.assignKeysToParamMap(configuration, rs, rsmd, keyProperties, (Map)parameter);
        } else if (parameter instanceof ArrayList && !((ArrayList)parameter).isEmpty() && ((ArrayList)parameter).get(0) instanceof MapperMethod.ParamMap) {
            this.assignKeysToParamMapList(configuration, rs, rsmd, keyProperties, (ArrayList)parameter);
        } else {
            this.assignKeysToParam(configuration, rs, rsmd, keyProperties, parameter);
        }
    }

    private void assignKeysToParam(Configuration configuration, ResultSet rs, ResultSetMetaData rsmd, String[] keyProperties, Object parameter) throws SQLException {
        Collection<?> params = Jdbc3KeyGenerator.collectionize(parameter);
        if (params.isEmpty()) {
            return;
        }
        ArrayList<KeyAssigner> assignerList = new ArrayList<KeyAssigner>();
        for (int i = 0; i < keyProperties.length; ++i) {
            assignerList.add(new KeyAssigner(configuration, rsmd, i + 1, null, keyProperties[i]));
        }
        Iterator<?> iterator = params.iterator();
        while (rs.next()) {
            if (!iterator.hasNext()) {
                throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, params.size()));
            }
            Object param = iterator.next();
            assignerList.forEach(x -> x.assign(rs, param));
        }
    }

    private void assignKeysToParamMapList(Configuration configuration, ResultSet rs, ResultSetMetaData rsmd, String[] keyProperties, ArrayList<MapperMethod.ParamMap<?>> paramMapList) throws SQLException {
        Iterator<MapperMethod.ParamMap<?>> iterator = paramMapList.iterator();
        ArrayList<KeyAssigner> assignerList = new ArrayList<KeyAssigner>();
        long counter = 0L;
        while (rs.next()) {
            if (!iterator.hasNext()) {
                throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, counter));
            }
            MapperMethod.ParamMap<?> paramMap = iterator.next();
            if (assignerList.isEmpty()) {
                for (int i = 0; i < keyProperties.length; ++i) {
                    assignerList.add(this.getAssignerForParamMap(configuration, rsmd, i + 1, paramMap, keyProperties[i], keyProperties, false).getValue());
                }
            }
            assignerList.forEach(x -> x.assign(rs, paramMap));
            ++counter;
        }
    }

    private void assignKeysToParamMap(Configuration configuration, ResultSet rs, ResultSetMetaData rsmd, String[] keyProperties, Map<String, ?> paramMap) throws SQLException {
        if (paramMap.isEmpty()) {
            return;
        }
        HashMap<String, Map.Entry> assignerMap = new HashMap<String, Map.Entry>();
        for (int i = 0; i < keyProperties.length; ++i) {
            Map.Entry<String, KeyAssigner> entry = this.getAssignerForParamMap(configuration, rsmd, i + 1, paramMap, keyProperties[i], keyProperties, true);
            Map.Entry iteratorPair = assignerMap.computeIfAbsent(entry.getKey(), k -> Jdbc3KeyGenerator.entry(Jdbc3KeyGenerator.collectionize(paramMap.get(k)).iterator(), new ArrayList()));
            ((List)iteratorPair.getValue()).add(entry.getValue());
        }
        long counter = 0L;
        while (rs.next()) {
            for (Map.Entry pair : assignerMap.values()) {
                if (!((Iterator)pair.getKey()).hasNext()) {
                    throw new ExecutorException(String.format(MSG_TOO_MANY_KEYS, counter));
                }
                Object param = ((Iterator)pair.getKey()).next();
                ((List)pair.getValue()).forEach(x -> x.assign(rs, param));
            }
            ++counter;
        }
    }

    private Map.Entry<String, KeyAssigner> getAssignerForParamMap(Configuration config, ResultSetMetaData rsmd, int columnPosition, Map<String, ?> paramMap, String keyProperty, String[] keyProperties, boolean omitParamName) {
        Set<String> keySet = paramMap.keySet();
        boolean singleParam = !keySet.contains(SECOND_GENERIC_PARAM_NAME);
        int firstDot = keyProperty.indexOf(46);
        if (firstDot == -1) {
            if (singleParam) {
                return this.getAssignerForSingleParam(config, rsmd, columnPosition, paramMap, keyProperty, omitParamName);
            }
            throw new ExecutorException("Could not determine which parameter to assign generated keys to. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString(keyProperties) + " and available parameters are " + keySet);
        }
        String paramName = keyProperty.substring(0, firstDot);
        if (keySet.contains(paramName)) {
            String argParamName = omitParamName ? null : paramName;
            String argKeyProperty = keyProperty.substring(firstDot + 1);
            return Jdbc3KeyGenerator.entry(paramName, new KeyAssigner(config, rsmd, columnPosition, argParamName, argKeyProperty));
        }
        if (singleParam) {
            return this.getAssignerForSingleParam(config, rsmd, columnPosition, paramMap, keyProperty, omitParamName);
        }
        throw new ExecutorException("Could not find parameter '" + paramName + "'. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString(keyProperties) + " and available parameters are " + keySet);
    }

    private Map.Entry<String, KeyAssigner> getAssignerForSingleParam(Configuration config, ResultSetMetaData rsmd, int columnPosition, Map<String, ?> paramMap, String keyProperty, boolean omitParamName) {
        String singleParamName = Jdbc3KeyGenerator.nameOfSingleParam(paramMap);
        String argParamName = omitParamName ? null : singleParamName;
        return Jdbc3KeyGenerator.entry(singleParamName, new KeyAssigner(config, rsmd, columnPosition, argParamName, keyProperty));
    }

    private static String nameOfSingleParam(Map<String, ?> paramMap) {
        return paramMap.keySet().iterator().next();
    }

    private static Collection<?> collectionize(Object param) {
        if (param instanceof Collection) {
            return (Collection)param;
        }
        if (param instanceof Object[]) {
            return Arrays.asList((Object[])param);
        }
        return Arrays.asList(param);
    }

    private static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    private class KeyAssigner {
        private final Configuration configuration;
        private final ResultSetMetaData rsmd;
        private final TypeHandlerRegistry typeHandlerRegistry;
        private final int columnPosition;
        private final String paramName;
        private final String propertyName;
        private TypeHandler<?> typeHandler;

        protected KeyAssigner(Configuration configuration, ResultSetMetaData rsmd, int columnPosition, String paramName, String propertyName) {
            this.configuration = configuration;
            this.rsmd = rsmd;
            this.typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            this.columnPosition = columnPosition;
            this.paramName = paramName;
            this.propertyName = propertyName;
        }

        protected void assign(ResultSet rs, Object param) {
            if (this.paramName != null) {
                param = ((MapperMethod.ParamMap)param).get(this.paramName);
            }
            MetaObject metaParam = this.configuration.newMetaObject(param);
            try {
                if (this.typeHandler == null) {
                    if (metaParam.hasSetter(this.propertyName)) {
                        Class<?> propertyType = metaParam.getSetterType(this.propertyName);
                        this.typeHandler = this.typeHandlerRegistry.getTypeHandler(propertyType, JdbcType.forCode(this.rsmd.getColumnType(this.columnPosition)));
                    } else {
                        throw new ExecutorException("No setter found for the keyProperty '" + this.propertyName + "' in '" + metaParam.getOriginalObject().getClass().getName() + "'.");
                    }
                }
                if (this.typeHandler != null) {
                    Object value = this.typeHandler.getResult(rs, this.columnPosition);
                    metaParam.setValue(this.propertyName, value);
                }
            }
            catch (SQLException e) {
                throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, e);
            }
        }
    }
}

