/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hook;

import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Owner;
import org.apache.gravitino.authorization.OwnerManager;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class TableHookDispatcher
implements TableDispatcher {
    private final TableDispatcher dispatcher;

    public TableHookDispatcher(TableDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        return this.dispatcher.listTables(namespace);
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        return this.dispatcher.loadTable(ident);
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        Table table = this.dispatcher.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
        OwnerManager ownerManager = GravitinoEnv.getInstance().ownerManager();
        if (ownerManager != null) {
            ownerManager.setOwner(ident.namespace().level(0), NameIdentifierUtil.toMetadataObject(ident, Entity.EntityType.TABLE), PrincipalUtils.getCurrentUserName(), Owner.Type.USER);
        }
        return table;
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        return this.dispatcher.alterTable(ident, changes);
    }

    public boolean dropTable(NameIdentifier ident) {
        return this.dispatcher.dropTable(ident);
    }

    public boolean purgeTable(NameIdentifier ident) throws UnsupportedOperationException {
        return this.dispatcher.purgeTable(ident);
    }

    public boolean tableExists(NameIdentifier ident) {
        return this.dispatcher.tableExists(ident);
    }
}

