/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.client;

import com.github.benmanes.caffeine.cache.Cache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.ForeignKeysResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsResponse;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsPsWithAuthResponse;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsResponse;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreClientCacheUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreClientCacheUtils.class);

    public static int getWeight(CacheKey key, Object val, HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimator) {
        IncrementalObjectSizeEstimator.ObjectEstimator keySizeEstimator = sizeEstimator.get(key.getClass());
        IncrementalObjectSizeEstimator.ObjectEstimator valSizeEstimator = sizeEstimator.get(key.IDENTIFIER.valueClass);
        int keySize = keySizeEstimator.estimate((Object)key, sizeEstimator);
        int valSize = valSizeEstimator.estimate(val, sizeEstimator);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache entry weight - key: {}, value: {}, total: {}", new Object[]{keySize, valSize, keySize + valSize});
        }
        return keySize + valSize;
    }

    public static String getQueryId() {
        try {
            return Hive.get().getConf().get(HiveConf.ConfVars.HIVE_QUERY_ID.varname);
        }
        catch (HiveException e) {
            LOG.error("Error getting query id. Query level and Global HMS caching will be disabled", (Throwable)e);
            return null;
        }
    }

    public static Pair<List<ColumnStatisticsObj>, List<String>> getTableColumnStatisticsCache(CacheI cache, String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList, TableWatermark watermark) {
        ArrayList<String> colStatsMissing = new ArrayList<String>();
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>();
        for (String colName : colNames) {
            CacheKey cacheKey = new CacheKey(KeyType.TABLE_COLUMN_STATS, watermark, dbName, tableName, colName, catName, validWriteIdList, engine, -1);
            ColumnStatisticsObj v = (ColumnStatisticsObj)cache.get(cacheKey);
            if (v == null) {
                colStatsMissing.add(colName);
                continue;
            }
            if (watermark == null) {
                LOG.debug("Query level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, colName={}", new Object[]{dbName, tableName, colName});
            } else {
                LOG.debug("HS2 level HMS cache: method=getTableColumnStatisticsInternal, dbName={}, tblName={}, colName={}", new Object[]{dbName, tableName, colName});
            }
            colStats.add(v);
        }
        return Pair.of(colStats, colStatsMissing);
    }

    public static void loadTableColumnStatisticsCache(CacheI cache, List<ColumnStatisticsObj> colStats, String catName, String dbName, String tableName, String engine, String validWriteIdList, TableWatermark watermark) {
        for (ColumnStatisticsObj colStat : colStats) {
            CacheKey cacheKey = new CacheKey(KeyType.TABLE_COLUMN_STATS, watermark, dbName, tableName, colStat.getColName(), catName, validWriteIdList, engine, -1);
            cache.put(cacheKey, colStat);
        }
    }

    public static List<ColumnStatisticsObj> computeTableColumnStatisticsFinal(List<String> originalColNames, List<ColumnStatisticsObj> colStats, List<ColumnStatisticsObj> newColStats) {
        ArrayList<ColumnStatisticsObj> result = new ArrayList<ColumnStatisticsObj>();
        int i = 0;
        int j = 0;
        for (String colName : originalColNames) {
            if (i >= colStats.size() || j >= newColStats.size()) break;
            if (colStats.get(i).getColName().equals(colName)) {
                result.add(colStats.get(i));
                ++i;
                continue;
            }
            if (!newColStats.get(j).getColName().equals(colName)) continue;
            result.add(newColStats.get(j));
            ++j;
        }
        while (i < colStats.size()) {
            result.add(colStats.get(i));
            ++i;
        }
        while (j < newColStats.size()) {
            result.add(newColStats.get(j));
            ++j;
        }
        return result;
    }

    public static Pair<List<Partition>, List<String>> getPartitionsByNamesCache(CacheI cache, GetPartitionsByNamesRequest rqst, TableWatermark watermark) throws MetaException {
        ArrayList<String> partitionsMissing = new ArrayList<String>();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String partitionName : rqst.getNames()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_BY_NAMES, watermark, rqst.getDb_name(), rqst.getTbl_name(), Warehouse.getPartValuesFromPartName((String)partitionName), rqst.isGet_col_stats(), rqst.getProcessorCapabilities(), rqst.getProcessorIdentifier(), rqst.getEngine(), rqst.getValidWriteIdList());
            Partition v = (Partition)cache.get(cacheKey);
            if (v == null) {
                partitionsMissing.add(partitionName);
                continue;
            }
            if (watermark == null) {
                LOG.debug("Query level HMS cache: method=getPartitionsByNamesInternal, dbName={}, tblName={}, partitionName={}", new Object[]{rqst.getDb_name(), rqst.getTbl_name(), partitionName});
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsByNamesInternal, dbName={}, tblName={}, partitionName={}", new Object[]{rqst.getDb_name(), rqst.getTbl_name(), partitionName});
            }
            partitions.add(v);
        }
        return Pair.of(partitions, partitionsMissing);
    }

    public static List<Partition> loadPartitionsByNamesCache(CacheI cache, GetPartitionsByNamesResult r, GetPartitionsByNamesRequest rqst, TableWatermark watermark) {
        ArrayList<Partition> newPartitions = new ArrayList<Partition>();
        for (Partition partition : r.getPartitions()) {
            CacheKey cacheKey = new CacheKey(KeyType.PARTITIONS_BY_NAMES, watermark, rqst.getDb_name(), rqst.getTbl_name(), partition.getValues(), rqst.isGet_col_stats(), rqst.getProcessorCapabilities(), rqst.getProcessorIdentifier(), rqst.getEngine(), rqst.getValidWriteIdList());
            cache.put(cacheKey, partition);
            newPartitions.add(partition);
        }
        return newPartitions;
    }

    public static GetPartitionsByNamesResult computePartitionsByNamesFinal(GetPartitionsByNamesRequest rqst, List<Partition> partitions, List<Partition> newPartitions) throws MetaException {
        ArrayList<Partition> result = new ArrayList<Partition>();
        int i = 0;
        int j = 0;
        for (String partitionName : rqst.getNames()) {
            if (i >= partitions.size() || j >= newPartitions.size()) break;
            List pv = Warehouse.getPartValuesFromPartName((String)partitionName);
            if (partitions.get(i).getValues().equals(pv)) {
                result.add(partitions.get(i));
                ++i;
                continue;
            }
            if (!newPartitions.get(j).getValues().equals(pv)) continue;
            result.add(newPartitions.get(j));
            ++j;
        }
        while (i < partitions.size()) {
            result.add(partitions.get(i));
            ++i;
        }
        while (j < newPartitions.size()) {
            result.add(newPartitions.get(j));
            ++j;
        }
        return new GetPartitionsByNamesResult(result);
    }

    public static class CacheKey {
        KeyType IDENTIFIER;
        List<Object> obj;

        public CacheKey(KeyType IDENTIFIER, Object ... objs) {
            this.IDENTIFIER = IDENTIFIER;
            this.obj = Collections.unmodifiableList(Arrays.asList(objs));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.IDENTIFIER == cacheKey.IDENTIFIER && Objects.equals(this.obj, cacheKey.obj);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.IDENTIFIER, this.obj});
        }

        public String toString() {
            return "CacheKey {" + this.IDENTIFIER.name() + " @@ " + this.obj.toString() + "}";
        }
    }

    public static enum KeyType {
        CONFIG_VALUE(String.class, new Class[0]),
        DATABASE(Database.class, String.class, String.class),
        TABLE(Table.class, GetTableRequest.class),
        PRIMARY_KEYS(PrimaryKeysResponse.class, PrimaryKeysRequest.class),
        FOREIGN_KEYS(ForeignKeysResponse.class, ForeignKeysRequest.class),
        UNIQUE_CONSTRAINTS(UniqueConstraintsResponse.class, UniqueConstraintsRequest.class),
        NOT_NULL_CONSTRAINTS(NotNullConstraintsResponse.class, NotNullConstraintsRequest.class),
        TABLE_COLUMN_STATS(ColumnStatisticsObj.class, String.class, Long.TYPE, TableWatermark.class),
        AGGR_COL_STATS(AggrStats.class, PartitionsStatsRequest.class, TableWatermark.class),
        PARTITIONS_BY_EXPR(PartitionsWrapper.class, PartitionsByExprRequest.class, TableWatermark.class),
        PARTITIONS_SPEC_BY_EXPR(PartitionSpecsWrapper.class, PartitionsByExprRequest.class, TableWatermark.class),
        LIST_PARTITIONS_ALL(PartitionNamesWrapper.class, String.class, Integer.TYPE, TableWatermark.class),
        LIST_PARTITIONS(String.class, Integer.TYPE),
        LIST_PARTITIONS_REQ(GetPartitionNamesPsResponse.class, GetPartitionNamesPsRequest.class),
        LIST_PARTITIONS_AUTH_INFO_ALL(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO(Partition.class, String.class, Integer.TYPE),
        LIST_PARTITIONS_AUTH_INFO_REQ(GetPartitionsPsWithAuthResponse.class, GetPartitionsPsWithAuthRequest.class),
        PARTITIONS_BY_NAMES(Partition.class, String.class, Boolean.TYPE, TableWatermark.class),
        VALID_WRITE_IDS(TableValidWriteIds.class, String.class, Long.TYPE),
        VALID_WRITE_ID(ValidWriteIdList.class, String.class, Long.TYPE),
        TABLE_ID(Long.class, String.class);

        public final List<Class<?>> keyClasses;
        public final Class<?> valueClass;

        private KeyType(Class<?> valueClass, Class<?> ... keyClasses) {
            this.keyClasses = Collections.unmodifiableList(Arrays.asList(keyClasses));
            this.valueClass = valueClass;
        }
    }

    public static interface CacheI {
        public void put(Object var1, Object var2);

        public Object get(Object var1);
    }

    public static interface Supplier<T, E extends Throwable> {
        public T get() throws E;
    }

    public static class TableWatermark {
        final String validWriteIdList;
        final long tableId;

        public TableWatermark(String validWriteIdList, long tableId) {
            this.validWriteIdList = validWriteIdList;
            this.tableId = tableId;
        }

        public boolean isValid() {
            return this.validWriteIdList != null && this.tableId != -1L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableWatermark that = (TableWatermark)o;
            return this.tableId == that.tableId && Objects.equals(this.validWriteIdList, that.validWriteIdList);
        }

        public int hashCode() {
            return Objects.hash(this.validWriteIdList, this.tableId);
        }

        public String toString() {
            return "TableWatermark {" + this.tableId + " @@ " + (this.validWriteIdList != null ? this.validWriteIdList : "null") + "}";
        }
    }

    public static class CacheWrapper
    implements CacheI {
        final Cache<CacheKey, Object> c;

        public CacheWrapper(Cache<CacheKey, Object> c) {
            this.c = c;
        }

        @Override
        public void put(Object k, Object v) {
            this.c.put((Object)((CacheKey)k), v);
        }

        @Override
        public Object get(Object k) {
            return this.c.getIfPresent(k);
        }
    }

    public static class PartitionSpecsWrapper {
        public final List<PartitionSpec> partitionSpecs;
        public final boolean hasUnknownPartition;

        public PartitionSpecsWrapper(List<PartitionSpec> partitionSpecs, boolean hasUnknownPartition) {
            this.partitionSpecs = partitionSpecs;
            this.hasUnknownPartition = hasUnknownPartition;
        }
    }

    public static class PartitionsWrapper {
        public final List<Partition> partitions;
        public final boolean hasUnknownPartition;

        public PartitionsWrapper(List<Partition> partitions, boolean hasUnknownPartition) {
            this.partitions = partitions;
            this.hasUnknownPartition = hasUnknownPartition;
        }
    }

    public static class PartitionNamesWrapper {
        public final List<String> partitionNames;

        public PartitionNamesWrapper(List<String> partitionNames) {
            this.partitionNames = partitionNames;
        }
    }
}

