/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.column.add;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Add Columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterTableAddColumnsDesc
extends AbstractAlterTableDesc {
    private static final long serialVersionUID = 1L;
    private final List<FieldSchema> newColumns;

    public AlterTableAddColumnsDesc(TableName tableName, Map<String, String> partitionSpec, boolean isCascade, List<FieldSchema> newColumns) throws SemanticException {
        super(AlterTableType.ADDCOLS, tableName, partitionSpec, null, isCascade, false, null);
        this.newColumns = newColumns;
    }

    public List<FieldSchema> getNewColumns() {
        return this.newColumns;
    }

    @Explain(displayName="new columns", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<String> getNewColsString() {
        return Utilities.getFieldSchemaString(this.newColumns);
    }

    @Override
    public boolean mayNeedWriteId() {
        return true;
    }
}

