/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.sun.management.UnixOperatingSystemMXBean;
import io.opentelemetry.api.metrics.DoubleGauge;
import io.opentelemetry.api.metrics.Meter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import org.apache.hadoop.hive.common.JvmMetrics;
import org.apache.hadoop.hive.common.JvmMetricsInfo;

public class OTELJavaMetrics {
    private final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final DoubleGauge memNonHeapUsedMGauge;
    private final DoubleGauge memNonHeapMaxM;
    private final DoubleGauge memHeapUsedM;
    private final DoubleGauge memHeapCommittedM;
    private final DoubleGauge memHeapMaxM;
    private final DoubleGauge memMaxM;
    private final DoubleGauge memNonHeapCommittedM;
    private final DoubleGauge threadsNew;
    private final DoubleGauge threadsRunnable;
    private final DoubleGauge threadsBlocked;
    private final DoubleGauge threadsWaiting;
    private final DoubleGauge threadsTimedWaiting;
    private final DoubleGauge threadsTerminated;
    private final DoubleGauge systemLoadAverage;
    private final DoubleGauge systemCpuLoad;
    private final DoubleGauge committedVirtualMemorySize;
    private final DoubleGauge processCpuTime;
    private final DoubleGauge freePhysicalMemorySize;
    private final DoubleGauge freeSwapSpaceSize;
    private final DoubleGauge totalPhysicalMemorySize;
    private final DoubleGauge processCpuLoad;
    static final float M = 1048576.0f;

    public OTELJavaMetrics(Meter meter) {
        this.memNonHeapUsedMGauge = meter.gaugeBuilder(JvmMetricsInfo.MemNonHeapUsedM.name()).build();
        this.memNonHeapCommittedM = meter.gaugeBuilder(JvmMetricsInfo.MemNonHeapCommittedM.name()).build();
        this.memNonHeapMaxM = meter.gaugeBuilder(JvmMetricsInfo.MemNonHeapMaxM.name()).build();
        this.memHeapUsedM = meter.gaugeBuilder(JvmMetricsInfo.MemHeapUsedM.name()).build();
        this.memHeapCommittedM = meter.gaugeBuilder(JvmMetricsInfo.MemHeapCommittedM.name()).build();
        this.memHeapMaxM = meter.gaugeBuilder(JvmMetricsInfo.MemHeapMaxM.name()).build();
        this.memMaxM = meter.gaugeBuilder(JvmMetricsInfo.MemMaxM.name()).build();
        this.threadsNew = meter.gaugeBuilder(JvmMetricsInfo.ThreadsNew.name()).build();
        this.threadsRunnable = meter.gaugeBuilder(JvmMetricsInfo.ThreadsRunnable.name()).build();
        this.threadsBlocked = meter.gaugeBuilder(JvmMetricsInfo.ThreadsBlocked.name()).build();
        this.threadsWaiting = meter.gaugeBuilder(JvmMetricsInfo.ThreadsWaiting.name()).build();
        this.threadsTimedWaiting = meter.gaugeBuilder(JvmMetricsInfo.ThreadsTimedWaiting.name()).build();
        this.threadsTerminated = meter.gaugeBuilder(JvmMetricsInfo.ThreadsTerminated.name()).build();
        this.systemLoadAverage = meter.gaugeBuilder("SystemLoadAverage").build();
        this.systemCpuLoad = meter.gaugeBuilder("SystemCpuLoad").build();
        this.committedVirtualMemorySize = meter.gaugeBuilder("CommittedVirtualMemorySize").build();
        this.processCpuTime = meter.gaugeBuilder("ProcessCpuTime").build();
        this.freePhysicalMemorySize = meter.gaugeBuilder("FreePhysicalMemorySize").build();
        this.freeSwapSpaceSize = meter.gaugeBuilder("FreeSwapSpaceSize").build();
        this.totalPhysicalMemorySize = meter.gaugeBuilder("TotalPhysicalMemorySize").build();
        this.processCpuLoad = meter.gaugeBuilder("ProcessCpuLoad").build();
    }

    public void setJvmMetrics() {
        this.setMemoryValuesValues();
        this.setThreadCountValues();
        this.setOsLevelValues();
    }

    private void setMemoryValuesValues() {
        MemoryUsage memNonHeap = this.memoryMXBean.getNonHeapMemoryUsage();
        MemoryUsage memHeap = this.memoryMXBean.getHeapMemoryUsage();
        Runtime runtime = Runtime.getRuntime();
        this.memNonHeapUsedMGauge.set((double)((float)memNonHeap.getUsed() / 1048576.0f));
        this.memNonHeapCommittedM.set((double)((float)memNonHeap.getCommitted() / 1048576.0f));
        this.memNonHeapMaxM.set((double)((float)memNonHeap.getMax() / 1048576.0f));
        this.memHeapUsedM.set((double)((float)memHeap.getUsed() / 1048576.0f));
        this.memHeapCommittedM.set((double)((float)memHeap.getCommitted() / 1048576.0f));
        this.memHeapMaxM.set((double)((float)memHeap.getMax() / 1048576.0f));
        this.memMaxM.set((double)((float)runtime.maxMemory() / 1048576.0f));
    }

    private void setThreadCountValues() {
        JvmMetrics.ThreadCountResult threadCountResult = JvmMetrics.getThreadCountResult(this.threadMXBean);
        this.threadsNew.set((double)threadCountResult.threadsNew);
        this.threadsRunnable.set((double)threadCountResult.threadsRunnable);
        this.threadsBlocked.set((double)threadCountResult.threadsBlocked);
        this.threadsWaiting.set((double)threadCountResult.threadsWaiting);
        this.threadsTimedWaiting.set((double)threadCountResult.threadsTimedWaiting);
        this.threadsTerminated.set((double)threadCountResult.threadsTerminated);
    }

    private void setOsLevelValues() {
        this.systemLoadAverage.set(this.osMXBean.getSystemLoadAverage());
        if (this.osMXBean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixMxBean = (UnixOperatingSystemMXBean)this.osMXBean;
            this.systemCpuLoad.set(unixMxBean.getSystemCpuLoad());
            this.committedVirtualMemorySize.set((double)unixMxBean.getCommittedVirtualMemorySize());
            this.processCpuTime.set((double)unixMxBean.getProcessCpuTime());
            this.freePhysicalMemorySize.set((double)unixMxBean.getFreePhysicalMemorySize());
            this.freeSwapSpaceSize.set((double)unixMxBean.getFreeSwapSpaceSize());
            this.totalPhysicalMemorySize.set((double)unixMxBean.getTotalPhysicalMemorySize());
            this.processCpuLoad.set(unixMxBean.getProcessCpuLoad());
        }
    }
}

