/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedBatchCommand;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;

public class AddWriteIdsToTxnToWriteIdCommand
implements ParameterizedBatchCommand<Object[]> {
    private final List<Object[]> params = new ArrayList<Object[]>();

    public AddWriteIdsToTxnToWriteIdCommand(String dbName, String tableName, long writeId, List<Long> txnIds, List<TxnToWriteId> txnToWriteIds) {
        for (long txnId : txnIds) {
            this.params.add(new Object[]{txnId, dbName, tableName, writeId});
            txnToWriteIds.add(new TxnToWriteId(txnId, writeId));
            ++writeId;
        }
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) {
        return "INSERT INTO \"TXN_TO_WRITE_ID\" (\"T2W_TXNID\",  \"T2W_DATABASE\", \"T2W_TABLE\", \"T2W_WRITEID\") VALUES (?, ?, ?, ?)";
    }

    @Override
    public List<Object[]> getQueryParameters() {
        return this.params;
    }

    @Override
    public ParameterizedPreparedStatementSetter<Object[]> getPreparedStatementSetter() {
        return (ps, argument) -> {
            ps.setLong(1, (Long)argument[0]);
            ps.setString(2, argument[1].toString());
            ps.setString(3, argument[2].toString());
            ps.setLong(4, (Long)argument[3]);
        };
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return null;
    }
}

