/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.json.BinaryEncoding;
import org.apache.hadoop.hive.serde2.json.HiveJsonReader;
import org.apache.hadoop.hive.serde2.json.HiveJsonWriter;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.TimestampParser;

@SerDeSpec(schemaProps={"columns", "columns.types", "timestamp.formats", "json.binary.format", "text.ignore.extra.fields", "json.stringify.complex.fields"})
public class JsonSerDe
extends AbstractSerDe {
    public static final String BINARY_FORMAT = "json.binary.format";
    public static final String STRINGIFY_COMPLEX = "json.stringify.complex.fields";
    public static final String IGNORE_EXTRA = "text.ignore.extra.fields";
    public static final String NULL_EMPTY_LINES = "text.null.empty.line";
    private BinaryEncoding binaryEncoding;
    private boolean nullEmptyLines;
    private HiveJsonReader jsonReader;
    private HiveJsonWriter jsonWriter;
    private StructTypeInfo rowTypeInfo;
    private StructObjectInspector soi;

    @Override
    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        this.initialize(configuration, tableProperties, partitionProperties, true);
    }

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties, boolean writeablePrimitivesDeserialize) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.initialize(configuration, this.properties, writeablePrimitivesDeserialize);
    }

    private void initialize(Configuration conf, Properties tbl, boolean writeablePrimitivesDeserialize) {
        String stringifyComplex;
        String ignoreExtras;
        log.debug("Initializing JsonSerDe: {}", tbl.entrySet());
        String nullEmpty = tbl.getProperty(NULL_EMPTY_LINES, "false");
        this.nullEmptyLines = Boolean.parseBoolean(nullEmpty);
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.getColumnNames(), this.getColumnTypes());
        this.soi = (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(this.rowTypeInfo);
        String parserFormats = tbl.getProperty("timestamp.formats");
        TimestampParser tsParser = parserFormats != null ? new TimestampParser(HiveStringUtils.splitAndUnEscape((String)parserFormats)) : new TimestampParser();
        String binaryEncodingStr = tbl.getProperty(BINARY_FORMAT, "base64");
        this.binaryEncoding = BinaryEncoding.valueOf(binaryEncodingStr.toUpperCase());
        this.jsonReader = new HiveJsonReader(this.soi, tsParser);
        this.jsonWriter = new HiveJsonWriter(this.binaryEncoding, this.getColumnNames());
        this.jsonReader.enable(HiveJsonReader.Feature.COL_INDEX_PARSING);
        if (writeablePrimitivesDeserialize) {
            this.jsonReader.enable(HiveJsonReader.Feature.PRIMITIVE_TO_WRITABLE);
        }
        if (Boolean.parseBoolean(ignoreExtras = tbl.getProperty(IGNORE_EXTRA, "true"))) {
            this.jsonReader.enable(HiveJsonReader.Feature.IGNORE_UNKNOWN_FIELDS);
        }
        if (Boolean.parseBoolean(stringifyComplex = tbl.getProperty(STRINGIFY_COMPLEX, "true"))) {
            this.jsonReader.enable(HiveJsonReader.Feature.STRINGIFY_COMPLEX_FIELDS);
        }
        log.debug("Initialized SerDe {}", (Object)this);
        log.debug("JSON Struct Reader: {}", (Object)this.jsonReader);
        log.debug("JSON Struct Writer: {}", (Object)this.jsonWriter);
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        Text t = (Text)blob;
        if (t.getLength() == 0) {
            if (!this.nullEmptyLines) {
                throw new SerDeException("Encountered an empty row in the text file");
            }
            int fieldCount = this.soi.getAllStructFieldRefs().size();
            return Collections.nCopies(fieldCount, null);
        }
        try {
            return this.jsonReader.parseStruct(new ByteArrayInputStream(t.getBytes(), 0, t.getLength()));
        }
        catch (Exception e) {
            log.debug("Problem parsing JSON text [{}]", (Object)t, (Object)e);
            throw new SerDeException(e);
        }
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        String jsonText = this.jsonWriter.write(obj, objInspector);
        return new Text(jsonText);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.jsonReader.getObjectInspector();
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public StructTypeInfo getTypeInfo() {
        return this.rowTypeInfo;
    }

    public BinaryEncoding getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public boolean isNullEmptyLines() {
        return this.nullEmptyLines;
    }
}

