/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.topnkey;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TopNKeyOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNKeyProcessor
implements SemanticNodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TopNKeyProcessor.class);
    private float efficiencyThreshold;
    private long checkEfficiencyNumBatches;
    private int maxTopNAllowed;
    private int maxNumberOfPartitions;

    public TopNKeyProcessor() {
    }

    public TopNKeyProcessor(int maxTopNAllowed, float efficiencyThreshold, long checkEfficiencyNumBatches, int maxNumberOfPartitions) {
        this.maxTopNAllowed = maxTopNAllowed;
        this.efficiencyThreshold = efficiencyThreshold;
        this.checkEfficiencyNumBatches = checkEfficiencyNumBatches;
        this.maxNumberOfPartitions = maxNumberOfPartitions;
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator reduceSinkOperator = (ReduceSinkOperator)nd;
        ReduceSinkDesc reduceSinkDesc = (ReduceSinkDesc)reduceSinkOperator.getConf();
        if (reduceSinkDesc.getTopN() < 0 || !reduceSinkDesc.isOrdering()) {
            return null;
        }
        if (reduceSinkDesc.getTopN() > this.maxTopNAllowed) {
            return null;
        }
        if (reduceSinkDesc.hasADistinctColumnIndex()) {
            return null;
        }
        Operator<OperatorDesc> parentOperator = reduceSinkOperator.getParentOperators().get(0);
        if (parentOperator instanceof TopNKeyOperator) {
            return null;
        }
        List<ExprNodeDesc> partitionCols = Collections.emptyList();
        if (reduceSinkDesc.isPTFReduceSink()) {
            if (reduceSinkDesc.getPartitionCols().size() >= reduceSinkDesc.getKeyCols().size()) {
                return null;
            }
            partitionCols = reduceSinkDesc.getPartitionCols();
        }
        TopNKeyDesc topNKeyDesc = new TopNKeyDesc(reduceSinkDesc.getTopN(), reduceSinkDesc.getOrder(), reduceSinkDesc.getNullOrder(), reduceSinkDesc.getKeyCols(), partitionCols, this.efficiencyThreshold, this.checkEfficiencyNumBatches, this.maxNumberOfPartitions);
        TopNKeyProcessor.copyDown(reduceSinkOperator, topNKeyDesc);
        reduceSinkDesc.setTopN(-1);
        return null;
    }

    public static Operator<? extends OperatorDesc> copyDown(Operator<? extends OperatorDesc> child, OperatorDesc operatorDesc) {
        List<Operator<OperatorDesc>> parents = child.getParentOperators();
        Operator<OperatorDesc> newOperator = OperatorFactory.getAndMakeChild(child.getCompilationOpContext(), operatorDesc, new RowSchema(parents.get(0).getSchema()), child.getParentOperators());
        newOperator.getChildOperators().add(child);
        for (Operator<OperatorDesc> parent : parents) {
            parent.removeChild(child);
        }
        child.getParentOperators().clear();
        child.getParentOperators().add(newOperator);
        return newOperator;
    }
}

