/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DateColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordReaderImpl
extends org.apache.orc.impl.RecordReaderImpl
implements RecordReader {
    static final Logger LOG = LoggerFactory.getLogger(RecordReaderImpl.class);
    private final VectorizedRowBatch batch;
    private int rowInBatch;
    private long baseRow;

    protected RecordReaderImpl(ReaderImpl fileReader, Reader.Options options, Configuration conf) throws IOException {
        super((org.apache.orc.impl.ReaderImpl)fileReader, options);
        boolean useDecimal64ColumnVectors = conf != null && HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        this.batch = useDecimal64ColumnVectors ? this.schema.createRowBatchV2() : this.schema.createRowBatch();
        this.rowInBatch = 0;
    }

    boolean ensureBatch() throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            this.baseRow = super.getRowNumber();
            this.rowInBatch = 0;
            return super.nextBatch(this.batch);
        }
        return true;
    }

    public VectorizedRowBatch createRowBatch(boolean useDecimal64) {
        return useDecimal64 ? this.schema.createRowBatchV2() : this.schema.createRowBatch();
    }

    public long getRowNumber() {
        return this.baseRow + (long)this.rowInBatch;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.ensureBatch();
    }

    public void seekToRow(long row) throws IOException {
        if (row >= this.baseRow && row < this.baseRow + (long)this.batch.size) {
            this.rowInBatch = (int)(row - this.baseRow);
        } else {
            super.seekToRow(row);
            this.batch.size = 0;
            this.ensureBatch();
        }
    }

    @Override
    public Object next(Object previous) throws IOException {
        if (!this.ensureBatch()) {
            return null;
        }
        if (this.schema.getCategory() == TypeDescription.Category.STRUCT) {
            OrcStruct result;
            List children = this.schema.getChildren();
            int numberOfChildren = children.size();
            if (previous == null || previous.getClass() != OrcStruct.class) {
                result = new OrcStruct(numberOfChildren);
                previous = result;
            } else {
                result = (OrcStruct)previous;
                if (result.getNumFields() != numberOfChildren) {
                    result.setNumFields(numberOfChildren);
                }
            }
            for (int i = 0; i < numberOfChildren; ++i) {
                result.setFieldValue(i, RecordReaderImpl.nextValue(this.batch.cols[i], this.rowInBatch, (TypeDescription)children.get(i), result.getFieldValue(i)));
            }
        } else {
            previous = RecordReaderImpl.nextValue(this.batch.cols[0], this.rowInBatch, this.schema, previous);
        }
        ++this.rowInBatch;
        return previous;
    }

    public boolean nextBatch(VectorizedRowBatch theirBatch) throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            if (this.batch.size > 0) {
                this.batch.reset();
            }
            this.baseRow = super.getRowNumber();
            this.rowInBatch = 0;
            return super.nextBatch(theirBatch);
        }
        this.copyIntoBatch(theirBatch, this.batch, this.rowInBatch);
        this.rowInBatch += theirBatch.size;
        return theirBatch.size > 0;
    }

    public void close() throws IOException {
        super.close();
        if (this.batch != null) {
            this.batch.cols = null;
        }
    }

    static BooleanWritable nextBoolean(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BooleanWritable result = previous == null || previous.getClass() != BooleanWritable.class ? new BooleanWritable() : (BooleanWritable)previous;
            result.set(((LongColumnVector)vector).vector[row] != 0L);
            return result;
        }
        return null;
    }

    static ByteWritable nextByte(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ByteWritable result = previous == null || previous.getClass() != ByteWritable.class ? new ByteWritable() : (ByteWritable)previous;
            result.set((byte)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static ShortWritable nextShort(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ShortWritable result = previous == null || previous.getClass() != ShortWritable.class ? new ShortWritable() : (ShortWritable)previous;
            result.set((short)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static IntWritable nextInt(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            IntWritable result = previous == null || previous.getClass() != IntWritable.class ? new IntWritable() : (IntWritable)previous;
            result.set((int)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static LongWritable nextLong(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            LongWritable result = previous == null || previous.getClass() != LongWritable.class ? new LongWritable() : (LongWritable)previous;
            result.set(((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static FloatWritable nextFloat(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            FloatWritable result = previous == null || previous.getClass() != FloatWritable.class ? new FloatWritable() : (FloatWritable)previous;
            result.set((float)((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static DoubleWritable nextDouble(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DoubleWritable result = previous == null || previous.getClass() != DoubleWritable.class ? new DoubleWritable() : (DoubleWritable)previous;
            result.set(((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    static Text nextString(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            Text result = previous == null || previous.getClass() != Text.class ? new Text() : (Text)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    static HiveCharWritable nextChar(ColumnVector vector, int row, int size, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveCharWritable result = previous == null || previous.getClass() != HiveCharWritable.class ? new HiveCharWritable() : (HiveCharWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.toString(row), size);
            return result;
        }
        return null;
    }

    static HiveVarcharWritable nextVarchar(ColumnVector vector, int row, int size, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveVarcharWritable result = previous == null || previous.getClass() != HiveVarcharWritable.class ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.toString(row), size);
            return result;
        }
        return null;
    }

    static BytesWritable nextBinary(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BytesWritable result = previous == null || previous.getClass() != BytesWritable.class ? new BytesWritable() : (BytesWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    static HiveDecimalWritable nextDecimal(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveDecimalWritable result = previous == null || previous.getClass() != HiveDecimalWritable.class ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
            if (vector instanceof Decimal64ColumnVector) {
                long value = ((Decimal64ColumnVector)vector).vector[row];
                result.deserialize64(value, (int)((Decimal64ColumnVector)vector).scale);
            } else {
                result.set(((DecimalColumnVector)vector).vector[row]);
            }
            return result;
        }
        return null;
    }

    static DateWritableV2 nextDate(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DateWritableV2 result = previous == null || previous.getClass() != DateWritableV2.class ? new DateWritableV2() : (DateWritableV2)previous;
            int date = (int)((DateColumnVector)vector).vector[row];
            result.set(date);
            return result;
        }
        return null;
    }

    static TimestampWritableV2 nextTimestamp(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            TimestampWritableV2 result = previous == null || previous.getClass() != TimestampWritableV2.class ? new TimestampWritableV2() : (TimestampWritableV2)previous;
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            result.setInternal(tcv.time[row], tcv.nanos[row]);
            return result;
        }
        return null;
    }

    static OrcStruct nextStruct(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            OrcStruct result;
            List childrenTypes = schema.getChildren();
            int numChildren = childrenTypes.size();
            if (previous == null || previous.getClass() != OrcStruct.class) {
                result = new OrcStruct(numChildren);
            } else {
                result = (OrcStruct)previous;
                result.setNumFields(numChildren);
            }
            StructColumnVector struct = (StructColumnVector)vector;
            for (int f = 0; f < numChildren; ++f) {
                result.setFieldValue(f, RecordReaderImpl.nextValue(struct.fields[f], row, (TypeDescription)childrenTypes.get(f), result.getFieldValue(f)));
            }
            return result;
        }
        return null;
    }

    static OrcUnion nextUnion(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            List childrenTypes = schema.getChildren();
            OrcUnion result = previous == null || previous.getClass() != OrcUnion.class ? new OrcUnion() : (OrcUnion)previous;
            UnionColumnVector union = (UnionColumnVector)vector;
            byte tag = (byte)union.tags[row];
            result.set(tag, RecordReaderImpl.nextValue(union.fields[tag], row, (TypeDescription)childrenTypes.get(tag), result.getObject()));
            return result;
        }
        return null;
    }

    static ArrayList<Object> nextList(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            int idx;
            ArrayList result = previous == null || previous.getClass() != ArrayList.class ? new ArrayList() : (ArrayList)previous;
            ListColumnVector list = (ListColumnVector)vector;
            int length = (int)list.lengths[row];
            int offset = (int)list.offsets[row];
            result.ensureCapacity(length);
            int oldLength = result.size();
            TypeDescription childType = (TypeDescription)schema.getChildren().get(0);
            for (idx = 0; idx < length && idx < oldLength; ++idx) {
                result.set(idx, RecordReaderImpl.nextValue(list.child, offset + idx, childType, result.get(idx)));
            }
            if (length < oldLength) {
                result.subList(length, result.size()).clear();
            } else if (oldLength < length) {
                while (idx < length) {
                    result.add(RecordReaderImpl.nextValue(list.child, offset + idx, childType, null));
                    ++idx;
                }
            }
            return result;
        }
        return null;
    }

    static Map<Object, Object> nextMap(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            LinkedHashMap result;
            MapColumnVector map = (MapColumnVector)vector;
            int length = (int)map.lengths[row];
            int offset = (int)map.offsets[row];
            TypeDescription keyType = (TypeDescription)schema.getChildren().get(0);
            TypeDescription valueType = (TypeDescription)schema.getChildren().get(1);
            if (previous == null || previous.getClass() != LinkedHashMap.class) {
                result = new LinkedHashMap(length);
            } else {
                result = (LinkedHashMap)previous;
                result.clear();
            }
            for (int e = 0; e < length; ++e) {
                result.put(RecordReaderImpl.nextValue(map.keys, e + offset, keyType, null), RecordReaderImpl.nextValue(map.values, e + offset, valueType, null));
            }
            return result;
        }
        return null;
    }

    static Object nextValue(ColumnVector vector, int row, TypeDescription schema, Object previous) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return RecordReaderImpl.nextBoolean(vector, row, previous);
            }
            case BYTE: {
                return RecordReaderImpl.nextByte(vector, row, previous);
            }
            case SHORT: {
                return RecordReaderImpl.nextShort(vector, row, previous);
            }
            case INT: {
                return RecordReaderImpl.nextInt(vector, row, previous);
            }
            case LONG: {
                return RecordReaderImpl.nextLong(vector, row, previous);
            }
            case FLOAT: {
                return RecordReaderImpl.nextFloat(vector, row, previous);
            }
            case DOUBLE: {
                return RecordReaderImpl.nextDouble(vector, row, previous);
            }
            case STRING: {
                return RecordReaderImpl.nextString(vector, row, previous);
            }
            case CHAR: {
                return RecordReaderImpl.nextChar(vector, row, schema.getMaxLength(), previous);
            }
            case VARCHAR: {
                return RecordReaderImpl.nextVarchar(vector, row, schema.getMaxLength(), previous);
            }
            case BINARY: {
                return RecordReaderImpl.nextBinary(vector, row, previous);
            }
            case DECIMAL: {
                return RecordReaderImpl.nextDecimal(vector, row, previous);
            }
            case DATE: {
                return RecordReaderImpl.nextDate(vector, row, previous);
            }
            case TIMESTAMP: {
                return RecordReaderImpl.nextTimestamp(vector, row, previous);
            }
            case STRUCT: {
                return RecordReaderImpl.nextStruct(vector, row, schema, previous);
            }
            case UNION: {
                return RecordReaderImpl.nextUnion(vector, row, schema, previous);
            }
            case LIST: {
                return RecordReaderImpl.nextList(vector, row, schema, previous);
            }
            case MAP: {
                return RecordReaderImpl.nextMap(vector, row, schema, previous);
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }

    void copyLongColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        LongColumnVector lsource = (LongColumnVector)source;
        LongColumnVector ldest = (LongColumnVector)destination;
        ldest.isRepeating = lsource.isRepeating;
        ldest.noNulls = lsource.noNulls;
        if (source.isRepeating) {
            ldest.isNull[0] = lsource.isNull[0];
            ldest.vector[0] = lsource.vector[0];
        } else if (!lsource.noNulls) {
            for (int r = 0; r < length; ++r) {
                ldest.isNull[r] = lsource.isNull[sourceOffset + r];
                ldest.vector[r] = lsource.vector[sourceOffset + r];
            }
        } else {
            for (int r = 0; r < length; ++r) {
                ldest.vector[r] = lsource.vector[sourceOffset + r];
            }
        }
    }

    void copyDoubleColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        DoubleColumnVector castedSource = (DoubleColumnVector)source;
        DoubleColumnVector castedDestination = (DoubleColumnVector)destination;
        if (source.isRepeating) {
            castedDestination.isRepeating = true;
            castedDestination.noNulls = castedSource.noNulls;
            castedDestination.isNull[0] = castedSource.isNull[0];
            castedDestination.vector[0] = castedSource.vector[0];
        } else {
            int r;
            if (!castedSource.noNulls) {
                castedDestination.noNulls = true;
                for (r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                }
            }
            for (r = 0; r < length; ++r) {
                castedDestination.vector[r] = castedSource.vector[sourceOffset + r];
            }
        }
    }

    void copyTimestampColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        TimestampColumnVector castedSource = (TimestampColumnVector)source;
        TimestampColumnVector castedDestination = (TimestampColumnVector)destination;
        castedDestination.isRepeating = castedSource.isRepeating;
        castedDestination.noNulls = castedSource.noNulls;
        if (source.isRepeating) {
            castedDestination.isNull[0] = castedSource.isNull[0];
            castedDestination.time[0] = castedSource.time[0];
            castedDestination.nanos[0] = castedSource.nanos[0];
        } else if (!castedSource.noNulls) {
            castedDestination.noNulls = true;
            for (int r = 0; r < length; ++r) {
                castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                castedDestination.time[r] = castedSource.time[sourceOffset + r];
                castedDestination.nanos[r] = castedSource.nanos[sourceOffset + r];
            }
        } else {
            for (int r = 0; r < length; ++r) {
                castedDestination.time[r] = castedSource.time[sourceOffset + r];
                castedDestination.nanos[r] = castedSource.nanos[sourceOffset + r];
            }
        }
    }

    void copyDecimalColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        block5: {
            DecimalColumnVector castedDestination;
            DecimalColumnVector castedSource;
            block4: {
                castedSource = (DecimalColumnVector)source;
                castedDestination = (DecimalColumnVector)destination;
                castedDestination.isRepeating = castedSource.isRepeating;
                castedDestination.noNulls = castedSource.noNulls;
                if (!source.isRepeating) break block4;
                castedDestination.isNull[0] = castedSource.isNull[0];
                if (castedSource.isNull[0]) break block5;
                castedDestination.set(0, castedSource.vector[0]);
                break block5;
            }
            if (!castedSource.noNulls) {
                for (int r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                    if (castedDestination.isNull[r]) continue;
                    castedDestination.set(r, castedSource.vector[r]);
                }
            } else {
                for (int r = 0; r < length; ++r) {
                    castedDestination.set(r, castedSource.vector[r]);
                }
            }
        }
    }

    void copyBytesColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        block5: {
            BytesColumnVector castedDestination;
            BytesColumnVector castedSource;
            block4: {
                castedSource = (BytesColumnVector)source;
                castedDestination = (BytesColumnVector)destination;
                castedDestination.isRepeating = castedSource.isRepeating;
                castedDestination.noNulls = castedSource.noNulls;
                if (!source.isRepeating) break block4;
                castedDestination.isNull[0] = castedSource.isNull[0];
                if (castedSource.isNull[0]) break block5;
                castedDestination.setVal(0, castedSource.vector[0], castedSource.start[0], castedSource.length[0]);
                break block5;
            }
            if (!castedSource.noNulls) {
                for (int r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                    if (castedDestination.isNull[r]) continue;
                    castedDestination.setVal(r, castedSource.vector[sourceOffset + r], castedSource.start[sourceOffset + r], castedSource.length[sourceOffset + r]);
                }
            } else {
                for (int r = 0; r < length; ++r) {
                    castedDestination.setVal(r, castedSource.vector[sourceOffset + r], castedSource.start[sourceOffset + r], castedSource.length[sourceOffset + r]);
                }
            }
        }
    }

    void copyStructColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        StructColumnVector castedSource = (StructColumnVector)source;
        StructColumnVector castedDestination = (StructColumnVector)destination;
        castedDestination.isRepeating = castedSource.isRepeating;
        castedDestination.noNulls = castedSource.noNulls;
        if (source.isRepeating) {
            castedDestination.isNull[0] = castedSource.isNull[0];
            for (int c = 0; c > castedSource.fields.length; ++c) {
                this.copyColumn(castedDestination.fields[c], castedSource.fields[c], 0, 1);
            }
        } else if (!castedSource.noNulls) {
            for (int r = 0; r < length; ++r) {
                castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
            }
        } else {
            for (int c = 0; c > castedSource.fields.length; ++c) {
                this.copyColumn(castedDestination.fields[c], castedSource.fields[c], sourceOffset, length);
            }
        }
    }

    void copyUnionColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        UnionColumnVector castedSource = (UnionColumnVector)source;
        UnionColumnVector castedDestination = (UnionColumnVector)destination;
        castedDestination.isRepeating = castedSource.isRepeating;
        castedDestination.noNulls = castedSource.noNulls;
        if (source.isRepeating) {
            int tag;
            castedDestination.isNull[0] = castedSource.isNull[0];
            castedDestination.tags[0] = tag = castedSource.tags[0];
            if (!castedDestination.isNull[0]) {
                this.copyColumn(castedDestination.fields[tag], castedSource.fields[tag], 0, 1);
            }
        } else {
            if (!castedSource.noNulls) {
                for (r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                    castedDestination.tags[r] = castedSource.tags[sourceOffset + r];
                }
            } else {
                for (r = 0; r < length; ++r) {
                    castedDestination.tags[r] = castedSource.tags[sourceOffset + r];
                }
            }
            for (int c = 0; c > castedSource.fields.length; ++c) {
                this.copyColumn(castedDestination.fields[c], castedSource.fields[c], sourceOffset, length);
            }
        }
    }

    void copyListColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        ListColumnVector castedSource = (ListColumnVector)source;
        ListColumnVector castedDestination = (ListColumnVector)destination;
        castedDestination.isRepeating = castedSource.noNulls;
        castedDestination.noNulls = castedSource.noNulls;
        if (source.isRepeating) {
            castedDestination.isNull[0] = castedSource.isNull[0];
            castedDestination.offsets[0] = 0L;
            castedDestination.lengths[0] = castedSource.lengths[0];
            this.copyColumn(castedDestination.child, castedSource.child, (int)castedSource.offsets[0], (int)castedSource.lengths[0]);
        } else {
            if (!castedSource.noNulls) {
                for (int r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                }
            }
            int minOffset = Integer.MAX_VALUE;
            int maxOffset = Integer.MIN_VALUE;
            for (int r = 0; r < length; ++r) {
                int childOffset = (int)castedSource.offsets[r + sourceOffset];
                int childLength = (int)castedSource.lengths[r + sourceOffset];
                castedDestination.offsets[r] = childOffset;
                castedDestination.lengths[r] = childLength;
                minOffset = Math.min(minOffset, childOffset);
                maxOffset = Math.max(maxOffset, childOffset + childLength);
            }
            if (minOffset <= maxOffset) {
                castedDestination.childCount = maxOffset - minOffset + 1;
                this.copyColumn(castedDestination.child, castedSource.child, minOffset, castedDestination.childCount);
            } else {
                castedDestination.childCount = 0;
            }
        }
    }

    void copyMapColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        MapColumnVector castedSource = (MapColumnVector)source;
        MapColumnVector castedDestination = (MapColumnVector)destination;
        castedDestination.isRepeating = castedSource.noNulls;
        castedDestination.noNulls = castedSource.noNulls;
        if (source.isRepeating) {
            castedDestination.isNull[0] = castedSource.isNull[0];
            castedDestination.offsets[0] = 0L;
            castedDestination.lengths[0] = castedSource.lengths[0];
            this.copyColumn(castedDestination.keys, castedSource.keys, (int)castedSource.offsets[0], (int)castedSource.lengths[0]);
            this.copyColumn(castedDestination.values, castedSource.values, (int)castedSource.offsets[0], (int)castedSource.lengths[0]);
        } else {
            if (!castedSource.noNulls) {
                for (int r = 0; r < length; ++r) {
                    castedDestination.isNull[r] = castedSource.isNull[sourceOffset + r];
                }
            }
            int minOffset = Integer.MAX_VALUE;
            int maxOffset = Integer.MIN_VALUE;
            for (int r = 0; r < length; ++r) {
                int childOffset = (int)castedSource.offsets[r + sourceOffset];
                int childLength = (int)castedSource.lengths[r + sourceOffset];
                castedDestination.offsets[r] = childOffset;
                castedDestination.lengths[r] = childLength;
                minOffset = Math.min(minOffset, childOffset);
                maxOffset = Math.max(maxOffset, childOffset + childLength);
            }
            if (minOffset <= maxOffset) {
                castedDestination.childCount = maxOffset - minOffset + 1;
                this.copyColumn(castedDestination.keys, castedSource.keys, minOffset, castedDestination.childCount);
                this.copyColumn(castedDestination.values, castedSource.values, minOffset, castedDestination.childCount);
            } else {
                castedDestination.childCount = 0;
            }
        }
    }

    void copyColumn(ColumnVector destination, ColumnVector source, int sourceOffset, int length) {
        if (source.getClass() == LongColumnVector.class) {
            this.copyLongColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == DoubleColumnVector.class) {
            this.copyDoubleColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == BytesColumnVector.class) {
            this.copyBytesColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == TimestampColumnVector.class) {
            this.copyTimestampColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == DecimalColumnVector.class) {
            this.copyDecimalColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == StructColumnVector.class) {
            this.copyStructColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == UnionColumnVector.class) {
            this.copyUnionColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == ListColumnVector.class) {
            this.copyListColumn(destination, source, sourceOffset, length);
        } else if (source.getClass() == MapColumnVector.class) {
            this.copyMapColumn(destination, source, sourceOffset, length);
        }
    }

    void copyIntoBatch(VectorizedRowBatch destination, VectorizedRowBatch source, int sourceStart) {
        int rows = Math.min(source.size - sourceStart, destination.getMaxSize());
        for (int c = 0; c < source.cols.length; ++c) {
            destination.cols[c].reset();
            this.copyColumn(destination.cols[c], source.cols[c], sourceStart, rows);
        }
        destination.size = rows;
    }
}

