/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.show.rolegrant;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.show.rolegrant.ShowRoleGrantDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;

public class ShowRoleGrantOperation
extends DDLOperation<ShowRoleGrantDesc> {
    public ShowRoleGrantOperation(DDLOperationContext context, ShowRoleGrantDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        boolean testMode = this.context.getConf().getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST);
        List<HiveRoleGrant> roles = authorizer.getRoleGrantInfoForPrincipal(AuthorizationUtils.getHivePrincipal(((ShowRoleGrantDesc)this.desc).getName(), ((ShowRoleGrantDesc)this.desc).getPrincipalType()));
        ShowUtils.writeToFile(this.writeRolesGrantedInfo(roles, testMode), ((ShowRoleGrantDesc)this.desc).getResFile(), this.context);
        return 0;
    }

    private String writeRolesGrantedInfo(List<HiveRoleGrant> roles, boolean testMode) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Collections.sort(roles);
        for (HiveRoleGrant role : roles) {
            ShowUtils.appendNonNull(builder, role.getRoleName(), true);
            ShowUtils.appendNonNull(builder, role.isGrantOption());
            ShowUtils.appendNonNull(builder, testMode ? -1L : (long)role.getGrantTime() * 1000L);
            ShowUtils.appendNonNull(builder, role.getGrantor());
        }
        return builder.toString();
    }
}

