/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.metadata;

import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Cache Metadata", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CacheMetadataDesc
implements DDLDesc {
    private final String dbName;
    private final String tableName;
    private final String partitionName;
    private final boolean isAllPartitions;

    public CacheMetadataDesc(String dbName, String tableName, String partitionName) {
        this(dbName, tableName, partitionName, false);
    }

    public CacheMetadataDesc(String dbName, String tableName, boolean isAllPartitions) {
        this(dbName, tableName, null, isAllPartitions);
    }

    private CacheMetadataDesc(String dbName, String tableName, String partitionName, boolean isAllPartitions) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partitionName = partitionName;
        this.isAllPartitions = isAllPartitions;
    }

    @Explain(displayName="db name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDbName() {
        return this.dbName;
    }

    @Explain(displayName="table name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTableName() {
        return this.tableName;
    }

    @Explain(displayName="partition name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPartitionName() {
        return this.partitionName;
    }

    @Explain(displayName="all partitions", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isAllPartitions() {
        return this.isAllPartitions;
    }
}

