/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidJson;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateTimeStringUtils;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class DruidJsonFilter
implements DruidJson {
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = ThreadLocal.withInitial(() -> DateTimeStringUtils.getDateFormatter((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
    protected final Type type;

    private static @Nullable DruidJsonFilter toEqualityKindDruidFilter(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexNode refNode;
        RexLiteral rexLiteral;
        if (rexNode.getKind() != SqlKind.EQUALS && rexNode.getKind() != SqlKind.NOT_EQUALS) {
            throw new AssertionError((Object)DruidQuery.format("Expecting EQUALS or NOT_EQUALS but got [%s]", rexNode.getKind()));
        }
        RexCall rexCall = (RexCall)rexNode;
        if (rexCall.getOperands().size() < 2) {
            return null;
        }
        RexNode lhs = (RexNode)rexCall.getOperands().get(0);
        RexNode rhs = (RexNode)rexCall.getOperands().get(1);
        if (lhs.getKind() == SqlKind.LITERAL && rhs.getKind() != SqlKind.LITERAL) {
            rexLiteral = (RexLiteral)lhs;
            refNode = rhs;
        } else if (rhs.getKind() == SqlKind.LITERAL && lhs.getKind() != SqlKind.LITERAL) {
            rexLiteral = (RexLiteral)rhs;
            refNode = lhs;
        } else {
            return null;
        }
        if (RexLiteral.isNullLiteral((RexNode)rexLiteral)) {
            return null;
        }
        String literalValue = DruidJsonFilter.toDruidLiteral((RexNode)rexLiteral, rowType, druidQuery);
        if (literalValue == null) {
            return null;
        }
        boolean isNumeric = refNode.getType().getFamily() == SqlTypeFamily.NUMERIC || rexLiteral.getType().getFamily() == SqlTypeFamily.NUMERIC;
        Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(refNode, rowType, druidQuery);
        String columnName = (String)druidColumn.left;
        ExtractionFunction extractionFunction = (ExtractionFunction)druidColumn.right;
        if (columnName == null) {
            return null;
        }
        DruidJsonFilter partialFilter = isNumeric ? new JsonBound(columnName, literalValue, false, literalValue, false, true, extractionFunction) : new JsonSelector(columnName, literalValue, extractionFunction);
        if (rexNode.getKind() == SqlKind.EQUALS) {
            return partialFilter;
        }
        return DruidJsonFilter.toNotDruidFilter(partialFilter);
    }

    private static @Nullable DruidJsonFilter toBoundDruidFilter(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        boolean lhsIsRef;
        RexNode refNode;
        RexLiteral rexLiteral;
        RexCall rexCall = (RexCall)rexNode;
        if (rexCall.getOperands().size() < 2) {
            return null;
        }
        RexNode lhs = (RexNode)rexCall.getOperands().get(0);
        RexNode rhs = (RexNode)rexCall.getOperands().get(1);
        if (lhs.getKind() == SqlKind.LITERAL && rhs.getKind() != SqlKind.LITERAL) {
            rexLiteral = (RexLiteral)lhs;
            refNode = rhs;
            lhsIsRef = false;
        } else if (rhs.getKind() == SqlKind.LITERAL && lhs.getKind() != SqlKind.LITERAL) {
            rexLiteral = (RexLiteral)rhs;
            refNode = lhs;
            lhsIsRef = true;
        } else {
            return null;
        }
        if (RexLiteral.isNullLiteral((RexNode)rexLiteral)) {
            return null;
        }
        String literalValue = DruidJsonFilter.toDruidLiteral((RexNode)rexLiteral, rowType, druidQuery);
        if (literalValue == null) {
            return null;
        }
        boolean isNumeric = refNode.getType().getFamily() == SqlTypeFamily.NUMERIC || rexLiteral.getType().getFamily() == SqlTypeFamily.NUMERIC;
        Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(refNode, rowType, druidQuery);
        String columnName = (String)druidColumn.left;
        ExtractionFunction extractionFunction = (ExtractionFunction)druidColumn.right;
        if (columnName == null) {
            return null;
        }
        switch (rexCall.getKind()) {
            case LESS_THAN_OR_EQUAL: 
            case LESS_THAN: {
                if (lhsIsRef) {
                    return new JsonBound(columnName, null, false, literalValue, rexCall.getKind() == SqlKind.LESS_THAN, isNumeric, extractionFunction);
                }
                return new JsonBound(columnName, literalValue, rexCall.getKind() == SqlKind.LESS_THAN, null, false, isNumeric, extractionFunction);
            }
            case GREATER_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                if (!lhsIsRef) {
                    return new JsonBound(columnName, null, false, literalValue, rexCall.getKind() == SqlKind.GREATER_THAN, isNumeric, extractionFunction);
                }
                return new JsonBound(columnName, literalValue, rexCall.getKind() == SqlKind.GREATER_THAN, null, false, isNumeric, extractionFunction);
            }
        }
        return null;
    }

    private static @Nullable String toDruidLiteral(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        String val;
        RexLiteral rhsLiteral = (RexLiteral)rexNode;
        if (SqlTypeName.NUMERIC_TYPES.contains(rhsLiteral.getTypeName())) {
            val = String.valueOf(RexLiteral.value((RexNode)rhsLiteral));
        } else if (SqlTypeName.CHAR_TYPES.contains(rhsLiteral.getTypeName())) {
            val = String.valueOf(RexLiteral.stringValue((RexNode)rhsLiteral));
        } else if (SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE == rhsLiteral.getTypeName() || SqlTypeName.TIMESTAMP == rhsLiteral.getTypeName() || SqlTypeName.DATE == rhsLiteral.getTypeName()) {
            Long millisSinceEpoch = DruidDateTimeUtils.literalValue(rexNode);
            if (millisSinceEpoch == null) {
                throw new AssertionError((Object)("Cannot translate Literal" + rexNode + " of type " + rhsLiteral.getTypeName() + " to TimestampString"));
            }
            val = DATE_FORMATTER.get().format(millisSinceEpoch);
        } else {
            val = null;
        }
        return val;
    }

    private static @Nullable DruidJsonFilter toIsNullKindDruidFilter(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        if (rexNode.getKind() != SqlKind.IS_NULL && rexNode.getKind() != SqlKind.IS_NOT_NULL) {
            throw new AssertionError((Object)DruidQuery.format("Expecting IS_NULL or IS_NOT_NULL but got [%s]", rexNode.getKind()));
        }
        RexCall rexCall = (RexCall)rexNode;
        RexNode refNode = (RexNode)rexCall.getOperands().get(0);
        Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(refNode, rowType, druidQuery);
        String columnName = (String)druidColumn.left;
        ExtractionFunction extractionFunction = (ExtractionFunction)druidColumn.right;
        if (columnName == null) {
            return null;
        }
        if (rexNode.getKind() == SqlKind.IS_NOT_NULL) {
            return DruidJsonFilter.toNotDruidFilter(new JsonSelector(columnName, null, extractionFunction));
        }
        return new JsonSelector(columnName, null, extractionFunction);
    }

    private static @Nullable DruidJsonFilter toInKindDruidFilter(RexNode e, RelDataType rowType, DruidQuery druidQuery) {
        switch (e.getKind()) {
            case DRUID_IN: 
            case DRUID_NOT_IN: {
                break;
            }
            default: {
                throw new AssertionError((Object)DruidQuery.format("Expecting IN or NOT IN but got [%s]", e.getKind()));
            }
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (RexNode rexNode : ((RexCall)e).getOperands()) {
            if (rexNode.getKind() != SqlKind.LITERAL) continue;
            String value = DruidJsonFilter.toDruidLiteral(rexNode, rowType, druidQuery);
            if (value == null) {
                return null;
            }
            listBuilder.add((Object)value);
        }
        Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn((RexNode)((RexCall)e).getOperands().get(0), rowType, druidQuery);
        String columnName = (String)druidColumn.left;
        ExtractionFunction extractionFunction = (ExtractionFunction)druidColumn.right;
        if (columnName == null) {
            return null;
        }
        if (e.getKind() != SqlKind.NOT_IN) {
            return new JsonInFilter(columnName, (List<String>)listBuilder.build(), extractionFunction);
        }
        return DruidJsonFilter.toNotDruidFilter(new JsonInFilter(columnName, (List<String>)listBuilder.build(), extractionFunction));
    }

    protected static @Nullable DruidJsonFilter toNotDruidFilter(DruidJsonFilter druidJsonFilter) {
        if (druidJsonFilter == null) {
            return null;
        }
        return new JsonCompositeFilter(Type.NOT, new DruidJsonFilter[]{druidJsonFilter});
    }

    private static @Nullable DruidJsonFilter toBetweenDruidFilter(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        if (rexNode.getKind() != SqlKind.BETWEEN) {
            return null;
        }
        RexCall rexCall = (RexCall)rexNode;
        if (rexCall.getOperands().size() < 4) {
            return null;
        }
        RexNode refNode = (RexNode)rexCall.getOperands().get(1);
        RexNode lhs = (RexNode)rexCall.getOperands().get(2);
        RexNode rhs = (RexNode)rexCall.getOperands().get(3);
        String lhsLiteralValue = DruidJsonFilter.toDruidLiteral(lhs, rowType, query);
        String rhsLiteralValue = DruidJsonFilter.toDruidLiteral(rhs, rowType, query);
        if (lhsLiteralValue == null || rhsLiteralValue == null) {
            return null;
        }
        boolean isNumeric = lhs.getType().getFamily() == SqlTypeFamily.NUMERIC || rhs.getType().getFamily() == SqlTypeFamily.NUMERIC;
        Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(refNode, rowType, query);
        String columnName = (String)druidColumn.left;
        ExtractionFunction extractionFunction = (ExtractionFunction)druidColumn.right;
        if (columnName == null) {
            return null;
        }
        return new JsonBound(columnName, lhsLiteralValue, false, rhsLiteralValue, false, isNumeric, extractionFunction);
    }

    private static @Nullable DruidJsonFilter toSimpleDruidFilter(RexNode e, RelDataType rowType, DruidQuery druidQuery) {
        switch (e.getKind()) {
            case EQUALS: 
            case NOT_EQUALS: {
                return DruidJsonFilter.toEqualityKindDruidFilter(e, rowType, druidQuery);
            }
            case LESS_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                return DruidJsonFilter.toBoundDruidFilter(e, rowType, druidQuery);
            }
            case BETWEEN: {
                return DruidJsonFilter.toBetweenDruidFilter(e, rowType, druidQuery);
            }
            case DRUID_IN: 
            case DRUID_NOT_IN: {
                return DruidJsonFilter.toInKindDruidFilter(e, rowType, druidQuery);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                return DruidJsonFilter.toIsNullKindDruidFilter(e, rowType, druidQuery);
            }
        }
        return null;
    }

    static @Nullable DruidJsonFilter toDruidFilters(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery, RexBuilder rexBuilder) {
        if ((rexNode = RexUtil.expandSearch((RexBuilder)rexBuilder, null, (RexNode)rexNode)).isAlwaysTrue()) {
            return JsonExpressionFilter.alwaysTrue();
        }
        if (rexNode.isAlwaysFalse()) {
            return JsonExpressionFilter.alwaysFalse();
        }
        switch (rexNode.getKind()) {
            case IS_TRUE: 
            case IS_NOT_FALSE: {
                return DruidJsonFilter.toDruidFilters((RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands()), rowType, druidQuery, rexBuilder);
            }
            case IS_NOT_TRUE: 
            case IS_FALSE: {
                DruidJsonFilter simpleFilter = DruidJsonFilter.toDruidFilters((RexNode)Iterables.getOnlyElement((Iterable)((RexCall)rexNode).getOperands()), rowType, druidQuery, rexBuilder);
                return simpleFilter != null ? new JsonCompositeFilter(Type.NOT, new DruidJsonFilter[]{simpleFilter}) : simpleFilter;
            }
            case AND: 
            case OR: 
            case NOT: {
                RexCall call = (RexCall)rexNode;
                ArrayList<DruidJsonFilter> jsonFilters = new ArrayList<DruidJsonFilter>();
                for (RexNode e : call.getOperands()) {
                    DruidJsonFilter druidFilter = DruidJsonFilter.toDruidFilters(e, rowType, druidQuery, rexBuilder);
                    if (druidFilter == null) {
                        return null;
                    }
                    jsonFilters.add(druidFilter);
                }
                return new JsonCompositeFilter(Type.valueOf(rexNode.getKind().name()), jsonFilters);
            }
        }
        DruidJsonFilter simpleLeafFilter = DruidJsonFilter.toSimpleDruidFilter(rexNode, rowType, druidQuery);
        return simpleLeafFilter == null ? DruidJsonFilter.toDruidExpressionFilter(rexNode, rowType, druidQuery) : simpleLeafFilter;
    }

    private static @Nullable DruidJsonFilter toDruidExpressionFilter(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        String expression = DruidExpressions.toDruidExpression(rexNode, rowType, query);
        return expression == null ? null : new JsonExpressionFilter(expression);
    }

    private DruidJsonFilter(Type type) {
        this.type = type;
    }

    public static DruidJsonFilter getSelectorFilter(String column, String value, ExtractionFunction extractionFunction) {
        Objects.requireNonNull(column, "column");
        return new JsonSelector(column, value, extractionFunction);
    }

    protected static class JsonDimHavingFilter
    implements DruidJson {
        private final DruidJsonFilter filter;

        public JsonDimHavingFilter(DruidJsonFilter filter) {
            this.filter = filter;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", "filter");
            DruidQuery.writeField(generator, "filter", this.filter);
            generator.writeEndObject();
        }
    }

    protected static class JsonInFilter
    extends DruidJsonFilter {
        private final String dimension;
        private final List<String> values;
        private final ExtractionFunction extractionFunction;

        protected JsonInFilter(String dimension, List<String> values, ExtractionFunction extractionFunction) {
            super(Type.IN);
            this.dimension = dimension;
            this.values = values;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeField(generator, "values", this.values);
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    private static class JsonCompositeFilter
    extends DruidJsonFilter {
        private final List<? extends DruidJsonFilter> fields;

        private JsonCompositeFilter(Type type, Iterable<? extends DruidJsonFilter> fields) {
            super(type);
            this.fields = ImmutableList.copyOf(fields);
        }

        private JsonCompositeFilter(Type type, DruidJsonFilter ... fields) {
            this(type, (Iterable<? extends DruidJsonFilter>)ImmutableList.copyOf((Object[])fields));
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            switch (this.type) {
                case NOT: {
                    DruidQuery.writeField(generator, "field", this.fields.get(0));
                    break;
                }
                default: {
                    DruidQuery.writeField(generator, "fields", this.fields);
                }
            }
            generator.writeEndObject();
        }
    }

    @VisibleForTesting
    protected static class JsonBound
    extends DruidJsonFilter {
        private final String dimension;
        private final String lower;
        private final boolean lowerStrict;
        private final String upper;
        private final boolean upperStrict;
        private final boolean alphaNumeric;
        private final ExtractionFunction extractionFunction;

        protected JsonBound(String dimension, String lower, boolean lowerStrict, String upper, boolean upperStrict, boolean alphaNumeric, ExtractionFunction extractionFunction) {
            super(Type.BOUND);
            this.dimension = dimension;
            this.lower = lower;
            this.lowerStrict = lowerStrict;
            this.upper = upper;
            this.upperStrict = upperStrict;
            this.alphaNumeric = alphaNumeric;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            if (this.lower != null) {
                generator.writeStringField("lower", this.lower);
                generator.writeBooleanField("lowerStrict", this.lowerStrict);
            }
            if (this.upper != null) {
                generator.writeStringField("upper", this.upper);
                generator.writeBooleanField("upperStrict", this.upperStrict);
            }
            if (this.alphaNumeric) {
                generator.writeStringField("ordering", "numeric");
            } else {
                generator.writeStringField("ordering", "lexicographic");
            }
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    private static class JsonSelector
    extends DruidJsonFilter {
        private final String dimension;
        private final String value;
        private final ExtractionFunction extractionFunction;

        private JsonSelector(String dimension, String value, ExtractionFunction extractionFunction) {
            super(Type.SELECTOR);
            this.dimension = dimension;
            this.value = value;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            generator.writeStringField("value", this.value);
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    public static class JsonExpressionFilter
    extends DruidJsonFilter {
        private final String expression;

        JsonExpressionFilter(String expression) {
            super(Type.EXPRESSION);
            this.expression = Objects.requireNonNull(expression, "expression");
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("expression", this.expression);
            generator.writeEndObject();
        }

        private static JsonExpressionFilter alwaysTrue() {
            return new JsonExpressionFilter("1 == 1");
        }

        private static JsonExpressionFilter alwaysFalse() {
            return new JsonExpressionFilter("1 == 2");
        }
    }

    protected static enum Type {
        AND,
        OR,
        NOT,
        SELECTOR,
        IN,
        BOUND,
        EXPRESSION;


        public String lowercase() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

