/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.compaction;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MajorCompactionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactionRequest.class);
    protected final Connection connection;
    protected final RegionInfo region;
    private Set<String> stores;

    MajorCompactionRequest(Connection connection, RegionInfo region) {
        this.connection = connection;
        this.region = region;
    }

    MajorCompactionRequest(Connection connection, RegionInfo region, Set<String> stores) {
        this(connection, region);
        this.stores = stores;
    }

    static Optional<MajorCompactionRequest> newRequest(Connection connection, RegionInfo info, Set<String> stores, long timestamp) throws IOException {
        MajorCompactionRequest request = new MajorCompactionRequest(connection, info, stores);
        return request.createRequest(connection, stores, timestamp);
    }

    RegionInfo getRegion() {
        return this.region;
    }

    Set<String> getStores() {
        return this.stores;
    }

    void setStores(Set<String> stores) {
        this.stores = stores;
    }

    Optional<MajorCompactionRequest> createRequest(Connection connection, Set<String> stores, long timestamp) throws IOException {
        Set<String> familiesToCompact = this.getStoresRequiringCompaction(stores, timestamp);
        MajorCompactionRequest request = null;
        if (!familiesToCompact.isEmpty()) {
            request = new MajorCompactionRequest(connection, this.region, familiesToCompact);
        }
        return Optional.ofNullable(request);
    }

    Set<String> getStoresRequiringCompaction(Set<String> requestedStores, long timestamp) throws IOException {
        HRegionFileSystem fileSystem = this.getFileSystem();
        HashSet familiesToCompact = Sets.newHashSet();
        for (String family : requestedStores) {
            if (!this.shouldCFBeCompacted(fileSystem, family, timestamp)) continue;
            familiesToCompact.add(family);
        }
        return familiesToCompact;
    }

    boolean shouldCFBeCompacted(HRegionFileSystem fileSystem, String family, long ts) throws IOException {
        StoreFileTracker sft = this.getStoreFileTracker(family, fileSystem);
        List<StoreFileInfo> storeFiles = sft.load();
        if (storeFiles == null) {
            LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName(), (Object)" has no store files");
            return false;
        }
        if (sft.hasReferences() && this.familyHasReferenceFile(fileSystem, family, ts)) {
            LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
            return true;
        }
        boolean includeStore = this.shouldIncludeStore(fileSystem, family, storeFiles, ts);
        if (!includeStore) {
            LOG.info("Excluding store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName() + " already compacted");
        }
        return includeStore;
    }

    public StoreFileTracker getStoreFileTracker(String family, HRegionFileSystem fileSystem) throws IOException {
        TableDescriptor htd = this.connection.getTable(this.getRegion().getTable()).getDescriptor();
        return StoreFileTrackerFactory.create(this.connection.getConfiguration(), htd, htd.getColumnFamily(family.getBytes()), fileSystem, false);
    }

    protected boolean shouldIncludeStore(HRegionFileSystem fileSystem, String family, Collection<StoreFileInfo> storeFiles, long ts) throws IOException {
        for (StoreFileInfo storeFile : storeFiles) {
            if (storeFile.getModificationTime() >= ts) continue;
            LOG.info("Including store: " + family + " with: " + storeFiles.size() + " files for compaction for region: " + fileSystem.getRegionInfo().getEncodedName());
            return true;
        }
        return false;
    }

    protected boolean familyHasReferenceFile(HRegionFileSystem fileSystem, String family, long ts) throws IOException {
        List<Path> referenceFiles = this.getReferenceFilePaths(fileSystem.getFileSystem(), fileSystem.getStoreDir(family));
        for (Path referenceFile : referenceFiles) {
            FileStatus status = fileSystem.getFileSystem().getFileLinkStatus(referenceFile);
            if (status.getModificationTime() >= ts) continue;
            LOG.info("Including store: " + family + " for compaction for region:  " + fileSystem.getRegionInfo().getEncodedName() + " (reference store files)");
            return true;
        }
        return false;
    }

    List<Path> getReferenceFilePaths(FileSystem fileSystem, Path familyDir) throws IOException {
        return FSUtils.getReferenceFilePaths(fileSystem, familyDir);
    }

    HRegionFileSystem getFileSystem() throws IOException {
        try (Admin admin = this.connection.getAdmin();){
            HRegionFileSystem hRegionFileSystem = HRegionFileSystem.openRegionFromFileSystem(admin.getConfiguration(), CommonFSUtils.getCurrentFileSystem((Configuration)admin.getConfiguration()), CommonFSUtils.getTableDir((Path)CommonFSUtils.getRootDir((Configuration)admin.getConfiguration()), (TableName)this.region.getTable()), this.region, true);
            return hRegionFileSystem;
        }
    }

    public String toString() {
        return "region: " + this.region.getEncodedName() + " store(s): " + this.stores;
    }
}

