/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaPackage;
import org.jruby.javasupport.JavaUtilities;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class Module {
    public static void define(Ruby runtime2) {
        RubyClass Module2 = runtime2.getModule();
        Module2.defineAnnotatedMethods(Module.class);
    }

    @JRubyMethod(name={"import"}, required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject import_(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        String name2;
        int i2;
        if (arg2 instanceof RubyString ? (i2 = (name2 = ((RubyString)arg2).decodeString()).lastIndexOf(46)) != -1 && i2 + 1 < name2.length() && Character.isUpperCase(name2.charAt(i2 + 1)) : arg2 instanceof RubyModule && ((RubyModule)arg2).getJavaProxy() && !(arg2 instanceof JavaPackage)) {
            return Module.java_import(context, self2, arg2, block);
        }
        return Module.include_package(context, self2, arg2);
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject java_import(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2 instanceof RubyArray) {
            return Module.java_import(context, self2, ((RubyArray)arg2).toJavaArrayMaybeUnsafe(), block);
        }
        return context.runtime.newArray(Module.javaImport(context, (RubyModule)self2, arg2, block));
    }

    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_import(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime2 = context.runtime;
        IRubyObject[] classes2 = ((RubyArray)RubyArray.newArrayNoCopy(runtime2, args2).flatten(context)).toJavaArrayMaybeUnsafe();
        for (int i2 = 0; i2 < classes2.length; ++i2) {
            classes2[i2] = Module.javaImport(context, (RubyModule)self2, classes2[i2], block);
        }
        return runtime2.newArray(classes2);
    }

    private static IRubyObject javaImport(ThreadContext context, RubyModule target, IRubyObject klass, Block block) {
        String constant;
        Class javaClass;
        Ruby runtime2 = context.runtime;
        if (klass instanceof RubyString) {
            String className = klass.asJavaString();
            if (!JavaUtilities.validJavaIdentifier(className)) {
                throw runtime2.newArgumentError("not a valid Java identifier: " + className);
            }
            if (className.contains("::")) {
                throw runtime2.newArgumentError("must use Java style name: " + className);
            }
            javaClass = Java.getJavaClass(runtime2, className, false);
        } else {
            if (klass instanceof JavaPackage) {
                throw runtime2.newArgumentError("java_import does not work for Java packages (try include_package instead)");
            }
            if (klass instanceof RubyModule) {
                javaClass = JavaClass.getJavaClassIfProxy(context, (RubyModule)klass);
                if (javaClass == null) {
                    throw runtime2.newArgumentError("not a Java class or interface: " + klass.inspect());
                }
            } else {
                throw runtime2.newArgumentError("invalid Java class or interface: " + klass.inspect() + " (of type " + klass.getType() + ")");
            }
        }
        if (block.isGiven()) {
            int i2 = javaClass.getName().lastIndexOf(46);
            String packageName = i2 != -1 ? javaClass.getName().substring(0, i2) : "";
            String className = javaClass.getSimpleName();
            IRubyObject ret = block.yieldSpecific(context, runtime2.newString(packageName), runtime2.newString(className));
            constant = ret.convertToString().asJavaString();
        } else {
            constant = javaClass.getSimpleName();
        }
        RubyModule proxyClass = Java.getProxyClass(runtime2, javaClass);
        try {
            if (!target.const_defined_p(context, runtime2.newSymbol(constant)).isTrue() || !target.getConstant(constant).equals(proxyClass)) {
                target.setConstant(constant, proxyClass);
            }
        }
        catch (NameError e) {
            String message2 = "cannot import Java class " + javaClass.getName() + " as `" + constant + "' : " + e.getException().getMessage();
            throw (RaiseException)runtime2.newNameError(message2, constant).initCause(e);
        }
        return proxyClass;
    }

    @JRubyMethod(required=2, visibility=Visibility.PRIVATE)
    public static IRubyObject java_alias(ThreadContext context, IRubyObject self2, IRubyObject new_id, IRubyObject old_id) {
        IncludedPackages includedPackages = Module.getIncludedPackages(context, (RubyModule)self2);
        if (!(new_id instanceof RubySymbol)) {
            new_id = new_id.convertToString().intern();
        }
        if (!(old_id instanceof RubySymbol)) {
            old_id = old_id.convertToString().intern();
        }
        includedPackages.javaAliases.put(((RubySymbol)new_id).idString(), ((RubySymbol)old_id).idString());
        return old_id;
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public static IRubyObject include_package(ThreadContext context, IRubyObject self2, IRubyObject pkg) {
        String packageName = pkg instanceof JavaPackage ? ((JavaPackage)pkg).getPackageName() : (pkg.respondsTo("package_name") ? pkg.callMethod(context, "package_name").convertToString().asJavaString() : pkg.convertToString().asJavaString());
        IncludedPackages includedPackages = Module.getIncludedPackages(context, (RubyModule)self2);
        return includedPackages.packages.add(packageName) ? pkg : context.nil;
    }

    private static IncludedPackages getIncludedPackages(ThreadContext context, RubyModule target) {
        IncludedPackages includedPackages = (IncludedPackages)target.getInternalVariable("includedPackages");
        if (includedPackages == null) {
            includedPackages = new IncludedPackages();
            target.setInternalVariable("includedPackages", includedPackages);
            ConstMissingMethod method2 = new ConstMissingMethod(target, includedPackages);
            Helpers.addInstanceMethod((RubyModule)target.getSingletonClass(), context.runtime.newSymbol("const_missing"), (DynamicMethod)method2, Visibility.PUBLIC, context, context.runtime);
        }
        return includedPackages;
    }

    private static final class ConstMissingMethod
    extends JavaMethod.JavaMethodOne {
        private final IncludedPackages includedPackages;

        ConstMissingMethod(RubyModule implClass, IncludedPackages includedPackages) {
            super(implClass, Visibility.PUBLIC, "const_missing");
            this.includedPackages = includedPackages;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject constant) {
            Ruby runtime2 = context.runtime;
            String constName = ((RubySymbol)constant).idString();
            String realName = this.includedPackages.javaAliases.getOrDefault(constName, constName);
            Class foundClass = null;
            for (String packageName : this.includedPackages.packages) {
                try {
                    foundClass = Java.loadJavaClass(runtime2, packageName + '.' + realName);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (foundClass == null) {
                try {
                    return Helpers.invokeSuper(context, self2, klass, "const_missing", constant, Block.NULL_BLOCK);
                }
                catch (NameError e) {
                    throw runtime2.newNameError(constant + " not found in packages: " + this.includedPackages.packages.stream().collect(Collectors.joining(", ")), constant);
                }
            }
            return Java.setProxyClass(runtime2, (RubyModule)self2, constName, foundClass);
        }
    }

    private static class IncludedPackages {
        final Collection<String> packages = new LinkedHashSet<String>(8);
        final Map<String, String> javaAliases = new HashMap<String, String>(4);

        IncludedPackages() {
        }
    }
}

