/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTable;
import org.apache.hadoop.hbase.backup.impl.BulkLoad;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class BackupMasterObserver
implements MasterCoprocessor,
MasterObserver {
    private static final Logger LOG = LoggerFactory.getLogger(BackupMasterObserver.class);

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        Configuration cfg = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        if (!BackupManager.isBackupEnabled(cfg)) {
            LOG.debug("Skipping postDeleteTable hook since backup is disabled");
            return;
        }
        this.deleteBulkLoads(cfg, tableName, ignored -> true);
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        Configuration cfg = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        if (!BackupManager.isBackupEnabled(cfg)) {
            LOG.debug("Skipping postTruncateTable hook since backup is disabled");
            return;
        }
        this.deleteBulkLoads(cfg, tableName, ignored -> true);
    }

    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor oldDescriptor, TableDescriptor currentDescriptor) throws IOException {
        Set newFamilies;
        Configuration cfg = ((MasterCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration();
        if (!BackupManager.isBackupEnabled(cfg)) {
            LOG.debug("Skipping postModifyTable hook since backup is disabled");
            return;
        }
        Set oldFamilies = Arrays.stream(oldDescriptor.getColumnFamilies()).map(ColumnFamilyDescriptor::getNameAsString).collect(Collectors.toSet());
        Sets.SetView removedFamilies = Sets.difference(oldFamilies, newFamilies = Arrays.stream(currentDescriptor.getColumnFamilies()).map(ColumnFamilyDescriptor::getNameAsString).collect(Collectors.toSet()));
        if (!removedFamilies.isEmpty()) {
            Predicate<BulkLoad> filter = arg_0 -> BackupMasterObserver.lambda$postModifyTable$2((Set)removedFamilies, arg_0);
            this.deleteBulkLoads(cfg, tableName, filter);
        }
    }

    private void deleteBulkLoads(Configuration config, TableName tableName, Predicate<BulkLoad> filter) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection((Configuration)config);
             BackupSystemTable tbl = new BackupSystemTable(connection);){
            List<BulkLoad> bulkLoads = tbl.readBulkloadRows((Collection<TableName>)ImmutableList.of((Object)tableName));
            List<byte[]> rowsToDelete = bulkLoads.stream().filter(filter).map(BulkLoad::getRowKey).collect(Collectors.toList());
            tbl.deleteBulkLoadedRows(rowsToDelete);
        }
    }

    private static /* synthetic */ boolean lambda$postModifyTable$2(Set removedFamilies, BulkLoad bulkload) {
        return removedFamilies.contains(bulkload.getColumnFamily());
    }
}

