/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface CGroupsHandler {
    public static final String CGROUP_PROCS_FILE = "cgroup.procs";
    public static final String CGROUP_PARAM_CLASSID = "classid";
    public static final String CGROUP_PARAM_BLKIO_WEIGHT = "weight";
    public static final String CGROUP_PARAM_MEMORY_HARD_LIMIT_BYTES = "limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_SWAP_HARD_LIMIT_BYTES = "memsw.limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_SOFT_LIMIT_BYTES = "soft_limit_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_OOM_CONTROL = "oom_control";
    public static final String CGROUP_PARAM_MEMORY_SWAPPINESS = "swappiness";
    public static final String CGROUP_PARAM_MEMORY_USAGE_BYTES = "usage_in_bytes";
    public static final String CGROUP_PARAM_MEMORY_MEMSW_USAGE_BYTES = "memsw.usage_in_bytes";
    public static final String CGROUP_NO_LIMIT = "-1";
    public static final String UNDER_OOM = "under_oom 1";
    public static final String CGROUP_CPU_PERIOD_US = "cfs_period_us";
    public static final String CGROUP_CPU_QUOTA_US = "cfs_quota_us";
    public static final String CGROUP_CPU_SHARES = "shares";

    public void initializeCGroupController(CGroupController var1) throws ResourceHandlerException;

    public String createCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public void deleteCGroup(CGroupController var1, String var2) throws ResourceHandlerException;

    public String getControllerPath(CGroupController var1);

    public String getRelativePathForCGroup(String var1);

    public String getPathForCGroup(CGroupController var1, String var2);

    public String getPathForCGroupTasks(CGroupController var1, String var2);

    public String getPathForCGroupParam(CGroupController var1, String var2, String var3);

    public void updateCGroupParam(CGroupController var1, String var2, String var3, String var4) throws ResourceHandlerException;

    public String getCGroupParam(CGroupController var1, String var2, String var3) throws ResourceHandlerException;

    public String getCGroupMountPath();

    public static enum CGroupController {
        CPU("cpu"),
        NET_CLS("net_cls"),
        BLKIO("blkio"),
        MEMORY("memory"),
        CPUACCT("cpuacct"),
        CPUSET("cpuset"),
        FREEZER("freezer"),
        DEVICES("devices");

        private final String name;

        private CGroupController(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Set<String> getValidCGroups() {
            HashSet<String> validCgroups = new HashSet<String>();
            for (CGroupController controller : CGroupController.values()) {
                validCgroups.add(controller.getName());
            }
            return validCgroups;
        }
    }
}

