/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.WithErasureCoding;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableDirectoryCreateCommand
extends RetriableCommand {
    private static final Logger LOG = LoggerFactory.getLogger(RetriableDirectoryCreateCommand.class);

    public RetriableDirectoryCreateCommand(String description) {
        super(description);
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        Path target = (Path)arguments[0];
        Mapper.Context context = (Mapper.Context)arguments[1];
        FileStatus sourceStatus = (FileStatus)arguments[2];
        FileSystem sourceFs = (FileSystem)arguments[3];
        FileSystem targetFS = target.getFileSystem(context.getConfiguration());
        if (!targetFS.mkdirs(target)) {
            return false;
        }
        boolean preserveEC = CopyMapper.getFileAttributeSettings(context).contains((Object)DistCpOptions.FileAttribute.ERASURECODINGPOLICY);
        if (preserveEC && sourceStatus.isErasureCoded() && FileUtil.checkFSSupportsEC((FileSystem)sourceFs, (Path)sourceStatus.getPath()) && FileUtil.checkFSSupportsEC((FileSystem)targetFS, (Path)target)) {
            ErasureCodingPolicy ecPolicy = SystemErasureCodingPolicies.getByName((String)((WithErasureCoding)sourceFs).getErasureCodingPolicyName(sourceStatus));
            LOG.debug("EC Policy for source path is {}", (Object)ecPolicy);
            WithErasureCoding ecFs = (WithErasureCoding)targetFS;
            if (ecPolicy != null) {
                ecFs.setErasureCodingPolicy(target, ecPolicy.getName());
            }
        }
        return true;
    }
}

