/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;

public class RMAppLogAggregation {
    private final boolean logAggregationEnabled;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private long logAggregationStartTime = 0L;
    private final long logAggregationStatusTimeout;
    private final Map<NodeId, LogAggregationReport> logAggregationStatus = new ConcurrentHashMap<NodeId, LogAggregationReport>();
    private volatile LogAggregationStatus logAggregationStatusForAppReport;
    private int logAggregationSucceed = 0;
    private int logAggregationFailed = 0;
    private Map<NodeId, List<String>> logAggregationDiagnosticsForNMs = new HashMap<NodeId, List<String>>();
    private Map<NodeId, List<String>> logAggregationFailureMessagesForNMs = new HashMap<NodeId, List<String>>();
    private final int maxLogAggregationDiagnosticsInMemory;

    RMAppLogAggregation(Configuration conf, ReentrantReadWriteLock.ReadLock readLock, ReentrantReadWriteLock.WriteLock writeLock) {
        this.readLock = readLock;
        this.writeLock = writeLock;
        this.logAggregationStatusTimeout = this.getLogAggregationStatusTimeout(conf);
        this.logAggregationEnabled = this.getEnabledFlagFromConf(conf);
        this.logAggregationStatusForAppReport = this.logAggregationEnabled ? LogAggregationStatus.NOT_START : LogAggregationStatus.DISABLED;
        this.maxLogAggregationDiagnosticsInMemory = this.getMaxLogAggregationDiagnostics(conf);
    }

    private long getLogAggregationStatusTimeout(Configuration conf) {
        long statusTimeout = conf.getLong("yarn.log-aggregation-status.time-out.ms", 600000L);
        if (statusTimeout <= 0L) {
            return 600000L;
        }
        return statusTimeout;
    }

    private boolean getEnabledFlagFromConf(Configuration conf) {
        return conf.getBoolean("yarn.log-aggregation-enable", false);
    }

    private int getMaxLogAggregationDiagnostics(Configuration conf) {
        return conf.getInt("yarn.resourcemanager.max-log-aggregation-diagnostics-in-memory", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<NodeId, LogAggregationReport> getLogAggregationReportsForApp(RMAppImpl rmApp) {
        this.readLock.lock();
        try {
            if (!this.isLogAggregationFinished() && RMAppImpl.isAppInFinalState(rmApp) && rmApp.getSystemClock().getTime() > this.logAggregationStartTime + this.logAggregationStatusTimeout) {
                for (Map.Entry entry : this.logAggregationStatus.entrySet()) {
                    if (((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.TIME_OUT) || ((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.SUCCEEDED) || ((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.FAILED)) continue;
                    ((LogAggregationReport)entry.getValue()).setLogAggregationStatus(LogAggregationStatus.TIME_OUT);
                }
            }
            Map<NodeId, LogAggregationReport> map = Collections.unmodifiableMap(this.logAggregationStatus);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aggregateLogReport(NodeId nodeId, LogAggregationReport report, RMAppImpl rmApp) {
        this.writeLock.lock();
        try {
            if (this.logAggregationEnabled && !this.isLogAggregationFinished()) {
                LogAggregationReport curReport = this.logAggregationStatus.get(nodeId);
                boolean stateChangedToFinal = false;
                if (curReport == null) {
                    this.logAggregationStatus.put(nodeId, report);
                    if (this.isLogAggregationFinishedForNM(report)) {
                        stateChangedToFinal = true;
                    }
                } else {
                    if (this.isLogAggregationFinishedForNM(report) && !this.isLogAggregationFinishedForNM(curReport)) {
                        stateChangedToFinal = true;
                    }
                    if (report.getLogAggregationStatus() != LogAggregationStatus.RUNNING || curReport.getLogAggregationStatus() != LogAggregationStatus.RUNNING_WITH_FAILURE) {
                        if (curReport.getLogAggregationStatus() == LogAggregationStatus.TIME_OUT && report.getLogAggregationStatus() == LogAggregationStatus.RUNNING && this.isThereFailureMessageForNM(nodeId)) {
                            report.setLogAggregationStatus(LogAggregationStatus.RUNNING_WITH_FAILURE);
                        }
                        curReport.setLogAggregationStatus(report.getLogAggregationStatus());
                    }
                }
                this.updateLogAggregationDiagnosticMessages(nodeId, report);
                if (RMAppImpl.isAppInFinalState(rmApp) && stateChangedToFinal) {
                    this.updateLogAggregationStatus(nodeId);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogAggregationStatus getLogAggregationStatusForAppReport(RMAppImpl rmApp) {
        boolean appInFinalState = RMAppImpl.isAppInFinalState(rmApp);
        this.readLock.lock();
        try {
            LogAggregationStatus logAggregationStatus;
            if (!this.logAggregationEnabled) {
                LogAggregationStatus logAggregationStatus2 = LogAggregationStatus.DISABLED;
                return logAggregationStatus2;
            }
            if (this.isLogAggregationFinished()) {
                LogAggregationStatus logAggregationStatus3 = this.logAggregationStatusForAppReport;
                return logAggregationStatus3;
            }
            Map<NodeId, LogAggregationReport> reports = this.getLogAggregationReportsForApp(rmApp);
            if (reports.size() == 0) {
                LogAggregationStatus logAggregationStatus4 = this.logAggregationStatusForAppReport;
                return logAggregationStatus4;
            }
            int logNotStartCount = 0;
            int logCompletedCount = 0;
            int logTimeOutCount = 0;
            int logFailedCount = 0;
            int logRunningWithFailure = 0;
            for (Map.Entry<NodeId, LogAggregationReport> report : reports.entrySet()) {
                switch (report.getValue().getLogAggregationStatus()) {
                    case NOT_START: {
                        ++logNotStartCount;
                        break;
                    }
                    case RUNNING_WITH_FAILURE: {
                        ++logRunningWithFailure;
                        break;
                    }
                    case SUCCEEDED: {
                        ++logCompletedCount;
                        break;
                    }
                    case FAILED: {
                        ++logFailedCount;
                        ++logCompletedCount;
                        break;
                    }
                    case TIME_OUT: {
                        ++logTimeOutCount;
                        ++logCompletedCount;
                        break;
                    }
                }
            }
            if (logNotStartCount == reports.size()) {
                logAggregationStatus = LogAggregationStatus.NOT_START;
                return logAggregationStatus;
            }
            if (logCompletedCount == reports.size()) {
                if (logFailedCount > 0 && appInFinalState) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.FAILED;
                    logAggregationStatus = LogAggregationStatus.FAILED;
                    return logAggregationStatus;
                }
                if (logTimeOutCount > 0) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.TIME_OUT;
                    logAggregationStatus = LogAggregationStatus.TIME_OUT;
                    return logAggregationStatus;
                }
                if (appInFinalState) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.SUCCEEDED;
                    logAggregationStatus = LogAggregationStatus.SUCCEEDED;
                    return logAggregationStatus;
                }
            } else if (logRunningWithFailure > 0) {
                logAggregationStatus = LogAggregationStatus.RUNNING_WITH_FAILURE;
                return logAggregationStatus;
            }
            logAggregationStatus = LogAggregationStatus.RUNNING;
            return logAggregationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isLogAggregationFinished() {
        return this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.SUCCEEDED) || this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.FAILED) || this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.TIME_OUT);
    }

    private boolean isLogAggregationFinishedForNM(LogAggregationReport report) {
        return report.getLogAggregationStatus() == LogAggregationStatus.SUCCEEDED || report.getLogAggregationStatus() == LogAggregationStatus.FAILED;
    }

    private void updateLogAggregationDiagnosticMessages(NodeId nodeId, LogAggregationReport report) {
        if (report.getDiagnosticMessage() != null && !report.getDiagnosticMessage().isEmpty()) {
            if (report.getLogAggregationStatus() == LogAggregationStatus.RUNNING) {
                List<String> diagnostics = this.logAggregationDiagnosticsForNMs.get(nodeId);
                if (diagnostics == null) {
                    diagnostics = new ArrayList<String>();
                    this.logAggregationDiagnosticsForNMs.put(nodeId, diagnostics);
                } else if (diagnostics.size() == this.maxLogAggregationDiagnosticsInMemory) {
                    diagnostics.remove(0);
                }
                diagnostics.add(report.getDiagnosticMessage());
                this.logAggregationStatus.get(nodeId).setDiagnosticMessage(StringUtils.join(diagnostics, (String)"\n"));
            } else if (report.getLogAggregationStatus() == LogAggregationStatus.RUNNING_WITH_FAILURE) {
                List<String> failureMessages = this.logAggregationFailureMessagesForNMs.get(nodeId);
                if (failureMessages == null) {
                    failureMessages = new ArrayList<String>();
                    this.logAggregationFailureMessagesForNMs.put(nodeId, failureMessages);
                } else if (failureMessages.size() == this.maxLogAggregationDiagnosticsInMemory) {
                    failureMessages.remove(0);
                }
                failureMessages.add(report.getDiagnosticMessage());
            }
        }
    }

    private void updateLogAggregationStatus(NodeId nodeId) {
        LogAggregationStatus status = this.logAggregationStatus.get(nodeId).getLogAggregationStatus();
        if (status.equals((Object)LogAggregationStatus.SUCCEEDED)) {
            ++this.logAggregationSucceed;
        } else if (status.equals((Object)LogAggregationStatus.FAILED)) {
            ++this.logAggregationFailed;
        }
        if (this.logAggregationSucceed == this.logAggregationStatus.size()) {
            this.logAggregationStatusForAppReport = LogAggregationStatus.SUCCEEDED;
            this.logAggregationStatus.clear();
            this.logAggregationDiagnosticsForNMs.clear();
            this.logAggregationFailureMessagesForNMs.clear();
        } else if (this.logAggregationSucceed + this.logAggregationFailed == this.logAggregationStatus.size()) {
            this.logAggregationStatusForAppReport = LogAggregationStatus.FAILED;
            this.logAggregationStatus.entrySet().removeIf(entry -> ((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.SUCCEEDED));
            this.logAggregationDiagnosticsForNMs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getLogAggregationFailureMessagesForNM(NodeId nodeId) {
        this.readLock.lock();
        try {
            List<String> failureMessages = this.logAggregationFailureMessagesForNMs.get(nodeId);
            if (failureMessages == null || failureMessages.isEmpty()) {
                String string = "";
                return string;
            }
            String string = StringUtils.join(failureMessages, (String)"\n");
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void recordLogAggregationStartTime(long time) {
        this.logAggregationStartTime = time;
    }

    public boolean isEnabled() {
        return this.logAggregationEnabled;
    }

    private boolean hasReportForNodeManager(NodeId nodeId) {
        return this.logAggregationStatus.containsKey(nodeId);
    }

    private void addReportForNodeManager(NodeId nodeId, LogAggregationReport report) {
        this.logAggregationStatus.put(nodeId, report);
    }

    public boolean isFinished() {
        return this.isLogAggregationFinished();
    }

    private boolean isThereFailureMessageForNM(NodeId nodeId) {
        return this.logAggregationFailureMessagesForNMs.get(nodeId) != null && !this.logAggregationFailureMessagesForNMs.get(nodeId).isEmpty();
    }

    long getLogAggregationStartTime() {
        return this.logAggregationStartTime;
    }

    void addReportIfNecessary(NodeId nodeId, ApplicationId applicationId) {
        if (!this.hasReportForNodeManager(nodeId)) {
            LogAggregationStatus status = this.isEnabled() ? LogAggregationStatus.NOT_START : LogAggregationStatus.DISABLED;
            this.addReportForNodeManager(nodeId, LogAggregationReport.newInstance(applicationId, status, ""));
        }
    }
}

