/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.http.jmx;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.shaded.org.glassfish.gmbal.Description;
import org.apache.hadoop.shaded.org.glassfish.gmbal.GmbalMBean;
import org.apache.hadoop.shaded.org.glassfish.gmbal.ManagedAttribute;
import org.apache.hadoop.shaded.org.glassfish.gmbal.ManagedObject;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.http.KeepAliveProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.apache.hadoop.shaded.org.glassfish.grizzly.monitoring.jmx.JmxObject;

@ManagedObject
@Description(value="The configuration for HTTP keep-alive connections.")
public class KeepAlive
extends JmxObject {
    private final org.apache.hadoop.shaded.org.glassfish.grizzly.http.KeepAlive keepAlive;
    private final AtomicInteger keepAliveConnectionsCount = new AtomicInteger();
    private final AtomicInteger keepAliveHitsCount = new AtomicInteger();
    private final AtomicInteger keepAliveRefusesCount = new AtomicInteger();
    private final AtomicInteger keepAliveTimeoutsCount = new AtomicInteger();
    private final JMXKeepAliveProbe keepAliveProbe = new JMXKeepAliveProbe();

    public KeepAlive(org.apache.hadoop.shaded.org.glassfish.grizzly.http.KeepAlive keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public String getJmxName() {
        return "Keep-Alive";
    }

    @Override
    protected void onRegister(GrizzlyJmxManager mom, GmbalMBean bean) {
        this.keepAlive.getMonitoringConfig().addProbes(this.keepAliveProbe);
    }

    @Override
    protected void onDeregister(GrizzlyJmxManager mom) {
        this.keepAlive.getMonitoringConfig().removeProbes(this.keepAliveProbe);
    }

    @ManagedAttribute(id="idle-timeout-seconds")
    @Description(value="The time period keep-alive connection may stay idle")
    public int getIdleTimeoutInSeconds() {
        return this.keepAlive.getIdleTimeoutInSeconds();
    }

    @ManagedAttribute(id="max-requests-count")
    @Description(value="the max number of HTTP requests allowed to be processed on one keep-alive connection")
    public int getMaxRequestsCount() {
        return this.keepAlive.getMaxRequestsCount();
    }

    @ManagedAttribute(id="live-connections-count")
    @Description(value="The number of live keep-alive connections")
    public int getConnectionsCount() {
        return this.keepAliveConnectionsCount.get();
    }

    @ManagedAttribute(id="hits-count")
    @Description(value="The number of requests processed on a keep-alive connections.")
    public int getHitsCount() {
        return this.keepAliveHitsCount.get();
    }

    @ManagedAttribute(id="refuses-count")
    @Description(value="The number of times keep-alive mode was refused.")
    public int getRefusesCount() {
        return this.keepAliveRefusesCount.get();
    }

    @ManagedAttribute(id="timeouts-count")
    @Description(value="The number of times idle keep-alive connections were closed by timeout.")
    public int getTimeoutsCount() {
        return this.keepAliveTimeoutsCount.get();
    }

    private final class JMXKeepAliveProbe
    implements KeepAliveProbe {
        private JMXKeepAliveProbe() {
        }

        @Override
        public void onConnectionAcceptEvent(Connection connection) {
            KeepAlive.this.keepAliveConnectionsCount.incrementAndGet();
            connection.addCloseListener(new Connection.CloseListener(){

                @Override
                public void onClosed(Connection connection, Connection.CloseType closeType) throws IOException {
                    KeepAlive.this.keepAliveConnectionsCount.decrementAndGet();
                }
            });
        }

        @Override
        public void onHitEvent(Connection connection, int requestCounter) {
            KeepAlive.this.keepAliveHitsCount.incrementAndGet();
        }

        @Override
        public void onRefuseEvent(Connection connection) {
            KeepAlive.this.keepAliveRefusesCount.incrementAndGet();
        }

        @Override
        public void onTimeoutEvent(Connection connection) {
            KeepAlive.this.keepAliveTimeoutsCount.incrementAndGet();
        }
    }
}

